/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.invocation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.core.ExceptionDepthComparator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public abstract class AbstractExceptionHandlerMethodResolver {
    private final Map<Class<? extends Throwable>, Method> mappedMethods = new ConcurrentReferenceHashMap(16);
    private final Map<Class<? extends Throwable>, Method> exceptionLookupCache = new ConcurrentReferenceHashMap(16);

    protected AbstractExceptionHandlerMethodResolver(Map<Class<? extends Throwable>, Method> mappedMethods) {
        Assert.notNull(mappedMethods, (String)"Mapped Methods must not be null");
        this.mappedMethods.putAll(mappedMethods);
    }

    protected static List<Class<? extends Throwable>> getExceptionsFromMethodSignature(Method method) {
        ArrayList<Class<? extends Throwable>> result = new ArrayList<Class<? extends Throwable>>();
        for (Class<?> paramType : method.getParameterTypes()) {
            if (!Throwable.class.isAssignableFrom(paramType)) continue;
            result.add(paramType);
        }
        Assert.notEmpty(result, (String)("No exception types mapped to {" + method + "}"));
        return result;
    }

    public boolean hasExceptionMappings() {
        return this.mappedMethods.size() > 0;
    }

    @Nullable
    public Method resolveMethod(Exception exception) {
        Throwable cause;
        Method method = this.resolveMethodByExceptionType(exception.getClass());
        if (method == null && (cause = exception.getCause()) != null) {
            method = this.resolveMethodByExceptionType(cause.getClass());
        }
        return method;
    }

    @Nullable
    public Method resolveMethodByExceptionType(Class<? extends Throwable> exceptionType) {
        Method method = this.exceptionLookupCache.get(exceptionType);
        if (method == null) {
            method = this.getMappedMethod(exceptionType);
            this.exceptionLookupCache.put(exceptionType, method);
        }
        return method;
    }

    @Nullable
    private Method getMappedMethod(Class<? extends Throwable> exceptionType) {
        ArrayList<Class<? extends Throwable>> matches = new ArrayList<Class<? extends Throwable>>();
        for (Class<? extends Throwable> mappedException : this.mappedMethods.keySet()) {
            if (!mappedException.isAssignableFrom(exceptionType)) continue;
            matches.add(mappedException);
        }
        if (!matches.isEmpty()) {
            Collections.sort(matches, new ExceptionDepthComparator(exceptionType));
            return this.mappedMethods.get(matches.get(0));
        }
        return null;
    }
}

