/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket;

import io.rsocket.RSocket;
import io.rsocket.RSocketFactory;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import io.rsocket.transport.netty.client.WebsocketClientTransport;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;
import org.springframework.messaging.rsocket.DefaultRSocketRequester;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import reactor.core.publisher.Mono;

final class DefaultRSocketRequesterBuilder
implements RSocketRequester.Builder {
    @Nullable
    private MimeType dataMimeType;
    private MimeType metadataMimeType = DefaultRSocketRequester.COMPOSITE_METADATA;
    private List<Consumer<RSocketFactory.ClientRSocketFactory>> factoryConfigurers = new ArrayList<Consumer<RSocketFactory.ClientRSocketFactory>>();
    @Nullable
    private RSocketStrategies strategies;
    private List<Consumer<RSocketStrategies.Builder>> strategiesConfigurers = new ArrayList<Consumer<RSocketStrategies.Builder>>();

    DefaultRSocketRequesterBuilder() {
    }

    @Override
    public RSocketRequester.Builder dataMimeType(@Nullable MimeType mimeType) {
        this.dataMimeType = mimeType;
        return this;
    }

    @Override
    public RSocketRequester.Builder metadataMimeType(MimeType mimeType) {
        Assert.notNull((Object)mimeType, (String)"`metadataMimeType` is required");
        this.metadataMimeType = mimeType;
        return this;
    }

    @Override
    public RSocketRequester.Builder rsocketFactory(Consumer<RSocketFactory.ClientRSocketFactory> configurer) {
        this.factoryConfigurers.add(configurer);
        return this;
    }

    @Override
    public RSocketRequester.Builder rsocketStrategies(@Nullable RSocketStrategies strategies) {
        this.strategies = strategies;
        return this;
    }

    @Override
    public RSocketRequester.Builder rsocketStrategies(Consumer<RSocketStrategies.Builder> configurer) {
        this.strategiesConfigurers.add(configurer);
        return this;
    }

    @Override
    public Mono<RSocketRequester> connectTcp(String host, int port) {
        return this.connect((ClientTransport)TcpClientTransport.create((String)host, (int)port));
    }

    @Override
    public Mono<RSocketRequester> connectWebSocket(URI uri) {
        return this.connect((ClientTransport)WebsocketClientTransport.create((URI)uri));
    }

    @Override
    public Mono<RSocketRequester> connect(ClientTransport transport) {
        return Mono.defer(() -> this.doConnect(transport));
    }

    private Mono<RSocketRequester> doConnect(ClientTransport transport) {
        RSocketStrategies rsocketStrategies = this.getRSocketStrategies();
        Assert.isTrue((!rsocketStrategies.encoders().isEmpty() ? 1 : 0) != 0, (String)"No encoders");
        Assert.isTrue((!rsocketStrategies.decoders().isEmpty() ? 1 : 0) != 0, (String)"No decoders");
        RSocketFactory.ClientRSocketFactory rsocketFactory = RSocketFactory.connect();
        MimeType dataMimeType = this.getDataMimeType(rsocketStrategies);
        rsocketFactory.dataMimeType(dataMimeType.toString());
        rsocketFactory.metadataMimeType(this.metadataMimeType.toString());
        this.factoryConfigurers.forEach(consumer -> consumer.accept(rsocketFactory));
        return rsocketFactory.transport(transport).start().map(rsocket -> new DefaultRSocketRequester((RSocket)rsocket, dataMimeType, this.metadataMimeType, rsocketStrategies));
    }

    private RSocketStrategies getRSocketStrategies() {
        if (!this.strategiesConfigurers.isEmpty()) {
            RSocketStrategies.Builder builder = this.strategies != null ? this.strategies.mutate() : RSocketStrategies.builder();
            this.strategiesConfigurers.forEach(c -> c.accept(builder));
            return builder.build();
        }
        return this.strategies != null ? this.strategies : RSocketStrategies.builder().build();
    }

    private MimeType getDataMimeType(RSocketStrategies strategies) {
        if (this.dataMimeType != null) {
            return this.dataMimeType;
        }
        return Stream.concat(strategies.encoders().stream().flatMap(encoder -> encoder.getEncodableMimeTypes().stream()), strategies.decoders().stream().flatMap(encoder -> encoder.getDecodableMimeTypes().stream())).filter(MimeType::isConcrete).findFirst().orElseThrow(() -> new IllegalArgumentException("Failed to select data MimeType to use."));
    }
}

