/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket;

import io.rsocket.ConnectionSetupPayload;
import io.rsocket.RSocket;
import io.rsocket.SocketAcceptor;
import java.util.function.BiFunction;
import org.springframework.lang.Nullable;
import org.springframework.messaging.rsocket.DefaultRSocketRequester;
import org.springframework.messaging.rsocket.MessagingRSocket;
import org.springframework.messaging.rsocket.RSocketMessageHandler;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public final class MessageHandlerAcceptor
extends RSocketMessageHandler
implements SocketAcceptor,
BiFunction<ConnectionSetupPayload, RSocket, RSocket> {
    @Nullable
    private MimeType defaultDataMimeType;
    private MimeType defaultMetadataMimeType = DefaultRSocketRequester.COMPOSITE_METADATA;

    public void setDefaultDataMimeType(@Nullable MimeType mimeType) {
        this.defaultDataMimeType = mimeType;
    }

    public void setDefaultMetadataMimeType(MimeType mimeType) {
        Assert.notNull((Object)mimeType, (String)"'metadataMimeType' is required");
        this.defaultMetadataMimeType = mimeType;
    }

    public Mono<RSocket> accept(ConnectionSetupPayload setupPayload, RSocket sendingRSocket) {
        MessagingRSocket rsocket = this.createRSocket(setupPayload, sendingRSocket);
        return rsocket.handleConnectionSetupPayload(setupPayload).then(Mono.just((Object)((Object)rsocket)));
    }

    @Override
    public RSocket apply(ConnectionSetupPayload setupPayload, RSocket sendingRSocket) {
        return this.createRSocket(setupPayload, sendingRSocket);
    }

    private MessagingRSocket createRSocket(ConnectionSetupPayload setupPayload, RSocket rsocket) {
        MimeType dataMimeType = StringUtils.hasText((String)setupPayload.dataMimeType()) ? MimeTypeUtils.parseMimeType((String)setupPayload.dataMimeType()) : this.defaultDataMimeType;
        Assert.notNull((Object)dataMimeType, (String)"No `dataMimeType` in the ConnectionSetupPayload and no default value");
        MimeType metadataMimeType = StringUtils.hasText((String)setupPayload.dataMimeType()) ? MimeTypeUtils.parseMimeType((String)setupPayload.metadataMimeType()) : this.defaultMetadataMimeType;
        Assert.notNull((Object)dataMimeType, (String)"No `metadataMimeType` in the ConnectionSetupPayload and no default value");
        RSocketRequester requester = RSocketRequester.wrap(rsocket, dataMimeType, metadataMimeType, this.getRSocketStrategies());
        return new MessagingRSocket(this, this.getRouteMatcher(), requester, dataMimeType, metadataMimeType, this.getRSocketStrategies().dataBufferFactory());
    }
}

