/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.support;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.async.AsyncWebUtils;
import org.springframework.web.context.request.async.WebAsyncManager;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenSessionInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_SESSION_FACTORY_BEAN_NAME = "sessionFactory";
    private String sessionFactoryBeanName = "sessionFactory";
    private boolean singleSession = true;
    private FlushMode flushMode = FlushMode.MANUAL;

    public void setSessionFactoryBeanName(String sessionFactoryBeanName) {
        this.sessionFactoryBeanName = sessionFactoryBeanName;
    }

    protected String getSessionFactoryBeanName() {
        return this.sessionFactoryBeanName;
    }

    public void setSingleSession(boolean singleSession) {
        this.singleSession = singleSession;
    }

    protected boolean isSingleSession() {
        return this.singleSession;
    }

    public void setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    protected FlushMode getFlushMode() {
        return this.flushMode;
    }

    protected boolean shouldFilterAsyncDispatches() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        SessionFactory sessionFactory;
        block8: {
            boolean participate;
            block10: {
                block9: {
                    sessionFactory = this.lookupSessionFactory(request);
                    participate = false;
                    WebAsyncManager asyncManager = AsyncWebUtils.getAsyncManager((ServletRequest)request);
                    boolean isFirstRequest = !this.isAsyncDispatch(request);
                    String key = this.getAlreadyFilteredAttributeName();
                    if (!this.isSingleSession()) break block9;
                    if (TransactionSynchronizationManager.hasResource((Object)sessionFactory)) {
                        participate = true;
                        break block10;
                    } else if (isFirstRequest || !asyncManager.initializeAsyncThread((Object)key)) {
                        this.logger.debug((Object)"Opening single Hibernate Session in OpenSessionInViewFilter");
                        Session session = this.getSession(sessionFactory);
                        SessionHolder sessionHolder = new SessionHolder(session);
                        TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder));
                        WebAsyncManager.WebAsyncThreadInitializer initializer = this.createAsyncThreadInitializer(sessionFactory, sessionHolder);
                        asyncManager.registerAsyncThreadInitializer((Object)key, initializer);
                    }
                    break block10;
                }
                Assert.state((boolean)this.isLastRequestThread(request), (String)"Deferred close mode is not supported on async dispatches");
                if (SessionFactoryUtils.isDeferredCloseActive(sessionFactory)) {
                    participate = true;
                } else {
                    SessionFactoryUtils.initDeferredClose(sessionFactory);
                }
            }
            try {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                Object var13_12 = null;
                if (participate) return;
                if (!this.isSingleSession()) break block8;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (participate) throw throwable;
                if (this.isSingleSession()) {
                    SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)sessionFactory));
                    if (!this.isLastRequestThread(request)) throw throwable;
                    this.logger.debug((Object)"Closing single Hibernate Session in OpenSessionInViewFilter");
                    this.closeSession(sessionHolder.getSession(), sessionFactory);
                    throw throwable;
                }
                SessionFactoryUtils.processDeferredClose(sessionFactory);
                throw throwable;
            }
            SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)sessionFactory));
            if (!this.isLastRequestThread(request)) return;
            this.logger.debug((Object)"Closing single Hibernate Session in OpenSessionInViewFilter");
            this.closeSession(sessionHolder.getSession(), sessionFactory);
            return;
        }
        SessionFactoryUtils.processDeferredClose(sessionFactory);
    }

    protected SessionFactory lookupSessionFactory(HttpServletRequest request) {
        return this.lookupSessionFactory();
    }

    protected SessionFactory lookupSessionFactory() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using SessionFactory '" + this.getSessionFactoryBeanName() + "' for OpenSessionInViewFilter"));
        }
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (SessionFactory)wac.getBean(this.getSessionFactoryBeanName(), SessionFactory.class);
    }

    protected Session getSession(SessionFactory sessionFactory) throws DataAccessResourceFailureException {
        Session session = SessionFactoryUtils.getSession(sessionFactory, true);
        FlushMode flushMode = this.getFlushMode();
        if (flushMode != null) {
            session.setFlushMode(flushMode);
        }
        return session;
    }

    protected void closeSession(Session session, SessionFactory sessionFactory) {
        SessionFactoryUtils.closeSession(session);
    }

    private WebAsyncManager.WebAsyncThreadInitializer createAsyncThreadInitializer(final SessionFactory sessionFactory, final SessionHolder sessionHolder) {
        return new WebAsyncManager.WebAsyncThreadInitializer(){

            public void initialize() {
                TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder));
            }

            public void reset() {
                TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
            }
        };
    }
}

