/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.support;

import java.io.IOException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.async.AsyncWebUtils;
import org.springframework.web.context.request.async.WebAsyncManager;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenEntityManagerInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_ENTITY_MANAGER_FACTORY_BEAN_NAME = "entityManagerFactory";
    private String entityManagerFactoryBeanName;
    private String persistenceUnitName;
    private volatile EntityManagerFactory entityManagerFactory;

    public void setEntityManagerFactoryBeanName(String entityManagerFactoryBeanName) {
        this.entityManagerFactoryBeanName = entityManagerFactoryBeanName;
    }

    protected String getEntityManagerFactoryBeanName() {
        return this.entityManagerFactoryBeanName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    protected String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    protected boolean shouldFilterAsyncDispatches() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        block10: {
            EntityManagerFactory emf = this.lookupEntityManagerFactory(request);
            boolean participate = false;
            WebAsyncManager asyncManager = AsyncWebUtils.getAsyncManager((ServletRequest)request);
            boolean isFirstRequest = !this.isAsyncDispatch(request);
            String key = this.getAlreadyFilteredAttributeName();
            if (TransactionSynchronizationManager.hasResource((Object)emf)) {
                participate = true;
            } else if (isFirstRequest || !asyncManager.initializeAsyncThread((Object)key)) {
                this.logger.debug((Object)"Opening JPA EntityManager in OpenEntityManagerInViewFilter");
                try {
                    EntityManager em = this.createEntityManager(emf);
                    EntityManagerHolder emHolder = new EntityManagerHolder(em);
                    TransactionSynchronizationManager.bindResource((Object)emf, (Object)((Object)emHolder));
                    WebAsyncManager.WebAsyncThreadInitializer initializer = this.createAsyncThreadInitializer(emf, emHolder);
                    asyncManager.registerAsyncThreadInitializer((Object)key, initializer);
                }
                catch (PersistenceException ex) {
                    throw new DataAccessResourceFailureException("Could not create JPA EntityManager", (Throwable)ex);
                }
            }
            try {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                Object var13_13 = null;
                if (participate) break block10;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (!participate) {
                    EntityManagerHolder emHolder = (EntityManagerHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)emf));
                    if (this.isLastRequestThread(request)) {
                        this.logger.debug((Object)"Closing JPA EntityManager in OpenEntityManagerInViewFilter");
                        EntityManagerFactoryUtils.closeEntityManager(emHolder.getEntityManager());
                    }
                }
                throw throwable;
            }
            EntityManagerHolder emHolder = (EntityManagerHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)emf));
            if (this.isLastRequestThread(request)) {
                this.logger.debug((Object)"Closing JPA EntityManager in OpenEntityManagerInViewFilter");
                EntityManagerFactoryUtils.closeEntityManager(emHolder.getEntityManager());
            }
        }
    }

    protected EntityManagerFactory lookupEntityManagerFactory(HttpServletRequest request) {
        if (this.entityManagerFactory == null) {
            this.entityManagerFactory = this.lookupEntityManagerFactory();
        }
        return this.entityManagerFactory;
    }

    protected EntityManagerFactory lookupEntityManagerFactory() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        String emfBeanName = this.getEntityManagerFactoryBeanName();
        String puName = this.getPersistenceUnitName();
        if (StringUtils.hasLength((String)emfBeanName)) {
            return (EntityManagerFactory)wac.getBean(emfBeanName, EntityManagerFactory.class);
        }
        if (!StringUtils.hasLength((String)puName) && wac.containsBean(DEFAULT_ENTITY_MANAGER_FACTORY_BEAN_NAME)) {
            return (EntityManagerFactory)wac.getBean(DEFAULT_ENTITY_MANAGER_FACTORY_BEAN_NAME, EntityManagerFactory.class);
        }
        return EntityManagerFactoryUtils.findEntityManagerFactory((ListableBeanFactory)wac, puName);
    }

    protected EntityManager createEntityManager(EntityManagerFactory emf) {
        return emf.createEntityManager();
    }

    private WebAsyncManager.WebAsyncThreadInitializer createAsyncThreadInitializer(final EntityManagerFactory emFactory, final EntityManagerHolder emHolder) {
        return new WebAsyncManager.WebAsyncThreadInitializer(){

            public void initialize() {
                TransactionSynchronizationManager.bindResource((Object)emFactory, (Object)((Object)emHolder));
            }

            public void reset() {
                TransactionSynchronizationManager.unbindResource((Object)emFactory);
            }
        };
    }
}

