/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.util.Map;
import javax.portlet.PortletRequest;
import org.springframework.beans.BeansException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.portlet.handler.AbstractMapBasedHandlerMapping;

public class ParameterHandlerMapping
extends AbstractMapBasedHandlerMapping {
    public static final String DEFAULT_PARAMETER_NAME = "action";
    private String parameterName = "action";
    private Map parameterMap;

    public void setParameterName(String parameterName) {
        Assert.hasText((String)parameterName, (String)"parameterName must not be null or empty");
        this.parameterName = parameterName;
    }

    public void setParameterMap(Map parameterMap) {
        this.parameterMap = parameterMap;
    }

    public void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        this.registerHandlers(this.parameterMap);
    }

    protected void registerHandlers(Map parameterMap) throws BeansException {
        if (CollectionUtils.isEmpty((Map)parameterMap)) {
            this.logger.warn((Object)"'parameterMap' is empty on ParameterHandlerMapping");
        } else {
            super.registerHandlers(parameterMap);
        }
    }

    protected Object getLookupKey(PortletRequest request) throws Exception {
        return request.getParameter(this.parameterName);
    }
}

