/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import org.springframework.beans.BeansException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.portlet.handler.AbstractMapBasedHandlerMapping;

public class PortletModeParameterHandlerMapping
extends AbstractMapBasedHandlerMapping {
    public static final String DEFAULT_PARAMETER_NAME = "action";
    private String parameterName = "action";
    private Map portletModeParameterMap;
    protected final Map modeHandlerMap = new HashMap();
    private boolean allowDuplicateParameters = false;
    private Set parametersUsed = new HashSet();

    public void setParameterName(String parameterName) {
        Assert.hasText((String)parameterName, (String)"'parameterName' must not be empty");
        this.parameterName = parameterName;
    }

    public void setPortletModeParameterMap(Map portletModeParameterMap) {
        this.portletModeParameterMap = portletModeParameterMap;
    }

    public void setAllowDuplicateParameters(boolean allowDuplicateParameters) {
        this.allowDuplicateParameters = allowDuplicateParameters;
    }

    public void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        this.registerHandlers(this.portletModeParameterMap);
    }

    protected void registerHandlers(Map portletModeParameterMap) throws BeansException {
        if (CollectionUtils.isEmpty((Map)portletModeParameterMap)) {
            this.logger.warn((Object)"'portletModeParameterMap' not set on PortletModeParameterHandlerMapping");
        } else {
            Iterator it = portletModeParameterMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String modeKey = (String)entry.getKey();
                PortletMode mode = new PortletMode(modeKey);
                Object parameterMap = entry.getValue();
                if (!(parameterMap instanceof Map)) {
                    throw new IllegalArgumentException("The value for the portlet mode must be a Map of parameter Strings to handler Objects");
                }
                this.registerHandler(mode, (Map)parameterMap);
            }
        }
    }

    protected void registerHandler(PortletMode mode, Map parameterMap) throws BeansException {
        Iterator it = parameterMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String parameter = (String)entry.getKey();
            Object handler = entry.getValue();
            this.registerHandler(mode, parameter, handler);
        }
    }

    protected void registerHandler(PortletMode mode, String parameter, Object handler) throws BeansException, IllegalStateException {
        if (!this.allowDuplicateParameters && this.parametersUsed.contains(parameter)) {
            throw new IllegalStateException("Duplicate entries for parameter [" + parameter + "] in different Portlet modes");
        }
        this.parametersUsed.add(parameter);
        this.registerHandler(new LookupKey(mode, parameter), handler);
    }

    protected Object getLookupKey(PortletRequest request) throws Exception {
        PortletMode mode = request.getPortletMode();
        String parameter = request.getParameter(this.parameterName);
        return new LookupKey(mode, parameter);
    }

    private static class LookupKey {
        private final PortletMode mode;
        private final String parameter;

        public LookupKey(PortletMode portletMode, String parameter) {
            this.mode = portletMode;
            this.parameter = parameter;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LookupKey)) {
                return false;
            }
            LookupKey otherKey = (LookupKey)other;
            return this.mode.equals((Object)otherKey.mode) && ObjectUtils.nullSafeEquals((Object)this.parameter, (Object)otherKey.parameter);
        }

        public int hashCode() {
            return this.mode.hashCode() * 29 + ObjectUtils.nullSafeHashCode((Object)this.parameter);
        }

        public String toString() {
            return "Portlet mode '" + this.mode + "', parameter '" + this.parameter + "'";
        }
    }
}

