/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.multipart;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.ActionRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.portlet.multipart.MultipartActionRequest;
import org.springframework.web.portlet.util.ActionRequestWrapper;

public class DefaultMultipartActionRequest
extends ActionRequestWrapper
implements MultipartActionRequest {
    private Map multipartFiles;
    private final Map multipartParameters;

    public DefaultMultipartActionRequest(ActionRequest request, Map multipartFiles, Map multipartParameters) {
        super(request);
        this.multipartFiles = Collections.unmodifiableMap(multipartFiles);
        this.multipartParameters = multipartParameters;
    }

    public Iterator getFileNames() {
        return this.multipartFiles.keySet().iterator();
    }

    public MultipartFile getFile(String name) {
        return (MultipartFile)this.multipartFiles.get(name);
    }

    public Map getFileMap() {
        return this.multipartFiles;
    }

    public Enumeration getParameterNames() {
        HashSet<Object> paramNames = new HashSet<Object>();
        Enumeration paramEnum = super.getParameterNames();
        while (paramEnum.hasMoreElements()) {
            paramNames.add(paramEnum.nextElement());
        }
        paramNames.addAll(this.multipartParameters.keySet());
        return Collections.enumeration(paramNames);
    }

    public String getParameter(String name) {
        String[] values = (String[])this.multipartParameters.get(name);
        if (values != null) {
            return values.length > 0 ? values[0] : null;
        }
        return super.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        String[] values = (String[])this.multipartParameters.get(name);
        if (values != null) {
            return values;
        }
        return super.getParameterValues(name);
    }

    public Map getParameterMap() {
        HashMap paramMap = new HashMap();
        paramMap.putAll(super.getParameterMap());
        paramMap.putAll(this.multipartParameters);
        return paramMap;
    }
}

