/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.rmi;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.rmi.server.RMIClassLoader;
import org.springframework.util.ClassUtils;

public class CodebaseAwareObjectInputStream
extends ObjectInputStream {
    private final String codebaseUrl;

    public CodebaseAwareObjectInputStream(InputStream in, String codebaseUrl) throws IOException {
        super(in);
        this.codebaseUrl = codebaseUrl;
    }

    protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        try {
            return super.resolveClass(classDesc);
        }
        catch (ClassNotFoundException ex) {
            Class clazz = ClassUtils.resolvePrimitiveClassName((String)classDesc.getName());
            if (clazz != null) {
                return clazz;
            }
            if (this.codebaseUrl == null) {
                throw ex;
            }
            return RMIClassLoader.loadClass(this.codebaseUrl, classDesc.getName());
        }
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        try {
            return super.resolveProxyClass(interfaces);
        }
        catch (ClassNotFoundException ex) {
            if (this.codebaseUrl == null) {
                throw ex;
            }
            ClassLoader loader = RMIClassLoader.getClassLoader(this.codebaseUrl);
            Class[] classObjs = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                classObjs[i] = Class.forName(interfaces[i], false, loader);
            }
            return Proxy.getProxyClass(loader, classObjs);
        }
    }
}

