/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.caucho;

import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.hessian.client.HessianRuntimeException;
import com.caucho.hessian.io.SerializerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.remoting.RemoteLookupFailureException;
import org.springframework.remoting.RemoteProxyFailureException;
import org.springframework.remoting.support.UrlBasedRemoteAccessor;
import org.springframework.util.Assert;

public class HessianClientInterceptor
extends UrlBasedRemoteAccessor
implements MethodInterceptor {
    private HessianProxyFactory proxyFactory = new HessianProxyFactory();
    private Object hessianProxy;

    public void setProxyFactory(HessianProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory != null ? proxyFactory : new HessianProxyFactory();
    }

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this.proxyFactory.setSerializerFactory(serializerFactory);
    }

    public void setSendCollectionType(boolean sendCollectionType) {
        this.proxyFactory.getSerializerFactory().setSendCollectionType(sendCollectionType);
    }

    public void setUsername(String username) {
        this.proxyFactory.setUser(username);
    }

    public void setPassword(String password) {
        this.proxyFactory.setPassword(password);
    }

    public void setOverloadEnabled(boolean overloadEnabled) {
        this.proxyFactory.setOverloadEnabled(overloadEnabled);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.prepare();
    }

    public void prepare() throws RemoteLookupFailureException {
        try {
            this.hessianProxy = this.createHessianProxy(this.proxyFactory);
        }
        catch (MalformedURLException ex) {
            throw new RemoteLookupFailureException("Service URL [" + this.getServiceUrl() + "] is invalid", ex);
        }
    }

    protected Object createHessianProxy(HessianProxyFactory proxyFactory) throws MalformedURLException {
        Assert.notNull((Object)this.getServiceInterface(), (String)"serviceInterface is required");
        return proxyFactory.create(this.getServiceInterface(), this.getServiceUrl());
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.hessianProxy == null) {
            throw new IllegalStateException("HessianClientInterceptor is not properly initialized - invoke 'prepare' before attempting any operations");
        }
        try {
            return invocation.getMethod().invoke(this.hessianProxy, invocation.getArguments());
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof HessianRuntimeException) {
                HessianRuntimeException hre = (HessianRuntimeException)ex.getTargetException();
                Object rootCause = hre.getRootCause() != null ? hre.getRootCause() : hre;
                throw this.convertHessianAccessException((Throwable)rootCause);
            }
            if (ex.getTargetException() instanceof UndeclaredThrowableException) {
                UndeclaredThrowableException utex = (UndeclaredThrowableException)ex.getTargetException();
                throw this.convertHessianAccessException(utex.getUndeclaredThrowable());
            }
            throw ex.getTargetException();
        }
        catch (Throwable ex) {
            throw new RemoteProxyFailureException("Failed to invoke Hessian proxy for remote service [" + this.getServiceUrl() + "]", ex);
        }
    }

    protected RemoteAccessException convertHessianAccessException(Throwable ex) {
        if (ex instanceof ConnectException) {
            throw new RemoteConnectFailureException("Cannot connect to Hessian remote service at [" + this.getServiceUrl() + "]", ex);
        }
        throw new RemoteAccessException("Cannot access Hessian remote service at [" + this.getServiceUrl() + "]", ex);
    }
}

