/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.groovy;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.io.IOException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.scripting.ScriptFactory;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.groovy.GroovyObjectCustomizer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class GroovyScriptFactory
implements ScriptFactory {
    private final String scriptSourceLocator;
    private final GroovyObjectCustomizer groovyObjectCustomizer;

    public GroovyScriptFactory(String scriptSourceLocator) {
        this(scriptSourceLocator, null);
    }

    public GroovyScriptFactory(String scriptSourceLocator, GroovyObjectCustomizer groovyObjectCustomizer) {
        Assert.hasText((String)scriptSourceLocator, (String)"'scriptSourceLocator' must not be empty");
        this.scriptSourceLocator = scriptSourceLocator;
        this.groovyObjectCustomizer = groovyObjectCustomizer;
    }

    public String getScriptSourceLocator() {
        return this.scriptSourceLocator;
    }

    public Class[] getScriptInterfaces() {
        return null;
    }

    public boolean requiresConfigInterface() {
        return false;
    }

    public Object getScriptedObject(ScriptSource actualScriptSource, Class[] actualInterfaces) throws IOException, ScriptCompilationException {
        ClassLoader cl = ClassUtils.getDefaultClassLoader();
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(cl);
        try {
            Class clazz = groovyClassLoader.parseClass(actualScriptSource.getScriptAsString());
            GroovyObject goo = (GroovyObject)clazz.newInstance();
            if (this.groovyObjectCustomizer != null) {
                this.groovyObjectCustomizer.customize(goo);
            }
            return goo;
        }
        catch (CompilationFailedException ex) {
            throw new ScriptCompilationException("Could not compile Groovy script: " + actualScriptSource, ex);
        }
        catch (InstantiationException ex) {
            throw new ScriptCompilationException("Could not instantiate Groovy script class: " + actualScriptSource, ex);
        }
        catch (IllegalAccessException ex) {
            throw new ScriptCompilationException("Could not access Groovy script constructor: " + actualScriptSource, ex);
        }
    }
}

