/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;

public class MockHttpRequest
implements HttpRequest {
    private final HttpHeaders headers = new HttpHeaders();
    private HttpMethod method;
    private URI uri;

    public MockHttpRequest(String uri) {
        this(HttpMethod.GET, uri);
    }

    public MockHttpRequest(HttpMethod method, String uri) {
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid uri: '" + uri + "'", e);
        }
        this.method = method;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URI getURI() {
        return this.uri;
    }
}

