/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.server.MvcResult;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;

public class TestDispatcherServlet
extends DispatcherServlet {
    public static final String MVC_RESULT_ATTRIBUTE = TestDispatcherServlet.class.getName() + ".MVC_RESULT";

    public TestDispatcherServlet(WebApplicationContext webApplicationContext) {
        super(webApplicationContext);
    }

    public MvcResult getMvcResult(HttpServletRequest request) {
        return (MvcResult)request.getAttribute(MVC_RESULT_ATTRIBUTE);
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Assert.isInstanceOf(MockHttpServletRequest.class, (Object)request, (String)("Request should be MockHttpServletRequest: " + request.getClass().getName()));
        Assert.isInstanceOf(MockHttpServletResponse.class, (Object)response, (String)("Response should be MockHttpServletResponse" + response.getClass().getName()));
        request.setAttribute(MVC_RESULT_ATTRIBUTE, (Object)new DefaultMvcResult((MockHttpServletRequest)request, (MockHttpServletResponse)response));
        super.doService(request, response);
    }

    protected HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        HandlerExecutionChain chain = super.getHandler(request);
        if (chain != null) {
            DefaultMvcResult mvcResult = (DefaultMvcResult)this.getMvcResult(request);
            mvcResult.setHandler(chain.getHandler());
            mvcResult.setInterceptors(chain.getInterceptors());
        }
        return chain;
    }

    protected void render(ModelAndView mv, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DefaultMvcResult mvcResult = (DefaultMvcResult)this.getMvcResult(request);
        mvcResult.setModelAndView(mv);
        super.render(mv, request, response);
    }

    protected ModelAndView processHandlerException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ModelAndView mav = super.processHandlerException(request, response, handler, ex);
        DefaultMvcResult mvcResult = (DefaultMvcResult)this.getMvcResult(request);
        mvcResult.setResolvedException(ex);
        mvcResult.setModelAndView(mav);
        return mav;
    }

    private static class DefaultMvcResult
    implements MvcResult {
        private final MockHttpServletRequest request;
        private final MockHttpServletResponse response;
        private Object handler;
        private HandlerInterceptor[] interceptors;
        private ModelAndView mav;
        private Exception resolvedException;

        public DefaultMvcResult(MockHttpServletRequest request, MockHttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public MockHttpServletRequest getRequest() {
            return this.request;
        }

        public MockHttpServletResponse getResponse() {
            return this.response;
        }

        public Object getHandler() {
            return this.handler;
        }

        public void setHandler(Object handler) {
            this.handler = handler;
        }

        public HandlerInterceptor[] getInterceptors() {
            return this.interceptors;
        }

        public void setInterceptors(HandlerInterceptor[] interceptors) {
            this.interceptors = interceptors;
        }

        public Exception getResolvedException() {
            return this.resolvedException;
        }

        public void setResolvedException(Exception resolvedException) {
            this.resolvedException = resolvedException;
        }

        public ModelAndView getModelAndView() {
            return this.mav;
        }

        public void setModelAndView(ModelAndView mav) {
            this.mav = mav;
        }

        public FlashMap getFlashMap() {
            return RequestContextUtils.getOutputFlashMap((HttpServletRequest)this.request);
        }
    }
}

