/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.result;

import java.io.OutputStream;
import java.io.PrintStream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.server.MvcResult;
import org.springframework.test.web.server.ResultHandler;
import org.springframework.test.web.server.result.ResultHandlerUtils;
import org.springframework.test.web.support.SimpleValuePrinter;
import org.springframework.test.web.support.ValuePrinter;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;

public class PrintingResultHandler
implements ResultHandler {
    private final OutputStream out;

    public PrintingResultHandler(OutputStream out) {
        this.out = out;
    }

    public final void handle(MvcResult mvcResult) throws Exception {
        String encoding = mvcResult.getResponse().getCharacterEncoding();
        PrintStream printStream = new PrintStream(this.out, true, encoding != null ? encoding : "ISO-8859-1");
        ValuePrinter printer = this.createValuePrinter(printStream);
        printer.printHeading("MockHttpServletRequest");
        this.printRequest(mvcResult.getRequest(), printer);
        printer.printHeading("Handler");
        this.printHandler(mvcResult.getHandler(), mvcResult.getInterceptors(), printer);
        printer.printHeading("Resolved Exception");
        this.printResolvedException(mvcResult.getResolvedException(), printer);
        printer.printHeading("ModelAndView");
        this.printModelAndView(mvcResult.getModelAndView(), printer);
        printer.printHeading("FlashMap");
        this.printFlashMap(RequestContextUtils.getOutputFlashMap((HttpServletRequest)mvcResult.getRequest()), printer);
        printer.printHeading("MockHttpServletResponse");
        this.printResponse(mvcResult.getResponse(), printer);
    }

    protected ValuePrinter createValuePrinter(PrintStream printStream) {
        return new SimpleValuePrinter(printStream);
    }

    protected void printRequest(MockHttpServletRequest request, ValuePrinter printer) throws Exception {
        printer.printValue("HTTP Method", request.getMethod());
        printer.printValue("Request URI", request.getRequestURI());
        printer.printValue("Parameters", request.getParameterMap());
        printer.printValue("Headers", ResultHandlerUtils.getRequestHeaderMap(request));
    }

    protected void printHandler(Object handler, HandlerInterceptor[] interceptors, ValuePrinter printer) throws Exception {
        if (handler == null) {
            printer.printValue("Type", null);
        } else if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            printer.printValue("Type", handlerMethod.getBeanType().getName());
            printer.printValue("Method", handlerMethod);
        } else {
            printer.printValue("Type", handler.getClass().getName());
        }
    }

    protected void printResolvedException(Exception resolvedException, ValuePrinter printer) throws Exception {
        if (resolvedException == null) {
            printer.printValue("Type", null);
        } else {
            printer.printValue("Type", resolvedException.getClass().getName());
        }
    }

    protected void printModelAndView(ModelAndView mav, ValuePrinter printer) throws Exception {
        printer.printValue("View name", mav != null ? mav.getViewName() : null);
        printer.printValue("View", mav != null ? mav.getView() : null);
        if (mav == null || mav.getModel().size() == 0) {
            printer.printValue("Model", null);
        } else {
            for (String name : mav.getModel().keySet()) {
                if (name.startsWith(BindingResult.MODEL_KEY_PREFIX)) continue;
                Object value = mav.getModel().get(name);
                printer.printValue("Attribute", name);
                printer.printValue("value", value);
                Errors errors = (Errors)mav.getModel().get(BindingResult.MODEL_KEY_PREFIX + name);
                if (errors == null) continue;
                printer.printValue("errors", errors.getAllErrors());
            }
        }
    }

    protected void printFlashMap(FlashMap flashMap, ValuePrinter printer) throws Exception {
        if (flashMap == null) {
            printer.printValue("Attributes", null);
        } else {
            for (String name : flashMap.keySet()) {
                printer.printValue("Attribute", name);
                printer.printValue("value", flashMap.get((Object)name));
            }
        }
    }

    protected void printResponse(MockHttpServletResponse response, ValuePrinter printer) throws Exception {
        printer.printValue("Status", response.getStatus());
        printer.printValue("Error message", response.getErrorMessage());
        printer.printValue("Headers", ResultHandlerUtils.getResponseHeaderMap(response));
        printer.printValue("Content type", response.getContentType());
        printer.printValue("Body", response.getContentAsString());
        printer.printValue("Forwarded URL", response.getForwardedUrl());
        printer.printValue("Redirected URL", response.getRedirectedUrl());
        printer.printValue("Cookies", response.getCookies());
    }
}

