/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.setup;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.springframework.core.NestedRuntimeException;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.test.web.server.MockMvc;
import org.springframework.test.web.server.TestDispatcherServlet;
import org.springframework.test.web.server.setup.MockMvcBuilder;
import org.springframework.web.context.WebApplicationContext;

public abstract class AbstractMockMvcBuilder
implements MockMvcBuilder {
    public final MockMvc build() {
        ServletContext servletContext = this.initServletContext();
        WebApplicationContext wac = this.initWebApplicationContext(servletContext);
        MockServletConfig config = new MockServletConfig(servletContext);
        TestDispatcherServlet dispatcherServlet = new TestDispatcherServlet(wac);
        try {
            dispatcherServlet.init((ServletConfig)config);
        }
        catch (ServletException ex) {
            throw new MockMvcBuildException("Failed to init DispatcherServlet", ex);
        }
        return new MockMvc(dispatcherServlet){};
    }

    protected abstract ServletContext initServletContext();

    protected abstract WebApplicationContext initWebApplicationContext(ServletContext var1);

    private static class MockMvcBuildException
    extends NestedRuntimeException {
        public MockMvcBuildException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

