/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.setup;

import org.springframework.test.web.server.setup.ContextMockMvcBuilder;
import org.springframework.test.web.server.setup.InitializedContextMockMvcBuilder;
import org.springframework.test.web.server.setup.MockMvcBuilder;
import org.springframework.test.web.server.setup.StandaloneMockMvcBuilder;
import org.springframework.util.Assert;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockMvcBuilders {
    public static ContextMockMvcBuilder annotationConfigSetup(Class<?> ... configClasses) {
        Assert.notEmpty((Object[])configClasses, (String)"At least one @Configuration class is required");
        AnnotationConfigWebApplicationContext context = new AnnotationConfigWebApplicationContext();
        context.register((Class[])configClasses);
        return new ContextMockMvcBuilder((ConfigurableWebApplicationContext)context);
    }

    public static ContextMockMvcBuilder xmlConfigSetup(String ... configLocations) {
        Assert.notEmpty((Object[])configLocations, (String)"At least one XML config location is required");
        XmlWebApplicationContext context = new XmlWebApplicationContext();
        context.setConfigLocations(configLocations);
        return new ContextMockMvcBuilder((ConfigurableWebApplicationContext)context);
    }

    public static MockMvcBuilder webApplicationContextSetup(WebApplicationContext context) {
        return new InitializedContextMockMvcBuilder(context);
    }

    public static StandaloneMockMvcBuilder standaloneSetup(Object ... controllers) {
        return new StandaloneMockMvcBuilder(controllers);
    }
}

