/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assume;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.springframework.test.annotation.Repeat;
import org.springframework.test.annotation.Timed;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit4.SpringTestMethod;

class SpringMethodRoadie {
    protected static final Log logger = LogFactory.getLog(SpringMethodRoadie.class);
    private final TestContextManager testContextManager;
    private final Object testInstance;
    private final SpringTestMethod testMethod;
    private Throwable testException;
    private final RunNotifier notifier;
    private final Description description;

    public SpringMethodRoadie(TestContextManager testContextManager, Object testInstance, SpringTestMethod testMethod, RunNotifier notifier, Description description) {
        this.testContextManager = testContextManager;
        this.testInstance = testInstance;
        this.testMethod = testMethod;
        this.notifier = notifier;
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block12: {
            if (this.getTestMethod().isIgnored()) {
                this.getNotifier().fireTestIgnored(this.getDescription());
                return;
            }
            this.getNotifier().fireTestStarted(this.getDescription());
            try {
                Timed timedAnnotation = this.getTestMethod().getMethod().getAnnotation(Timed.class);
                long springTimeout = timedAnnotation != null && timedAnnotation.millis() > 0L ? timedAnnotation.millis() : 0L;
                long junitTimeout = this.getTestMethod().getTimeout();
                if (springTimeout > 0L && junitTimeout > 0L) {
                    String msg = "Test method [" + this.getTestMethod().getMethod() + "] has been configured with Spring's @Timed(millis=" + springTimeout + ") and JUnit's @Test(timeout=" + junitTimeout + ") annotations. Only one declaration of a 'timeout' is permitted per test method.";
                    logger.error((Object)msg);
                    throw new IllegalStateException(msg);
                }
                if (springTimeout > 0L) {
                    long startTime = System.currentTimeMillis();
                    try {
                        this.runTest();
                        break block12;
                    }
                    finally {
                        long elapsed = System.currentTimeMillis() - startTime;
                        if (elapsed > springTimeout) {
                            this.addFailure(new Exception("Took " + elapsed + " ms; limit was " + springTimeout));
                        }
                    }
                }
                if (junitTimeout > 0L) {
                    this.runWithTimeout(junitTimeout);
                } else {
                    this.runTest();
                }
            }
            finally {
                this.getNotifier().fireTestFinished(this.getDescription());
            }
        }
    }

    protected void runWithTimeout(final long timeout) {
        this.runWithRepetitions(new Runnable(){

            public void run() {
                ExecutorService service = Executors.newSingleThreadExecutor();
                Callable<Object> callable = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        SpringMethodRoadie.this.runTestMethod();
                        return null;
                    }
                };
                Future<Object> result = service.submit(callable);
                service.shutdown();
                try {
                    boolean terminated = service.awaitTermination(timeout, TimeUnit.MILLISECONDS);
                    if (!terminated) {
                        service.shutdownNow();
                    }
                    result.get(0L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    SpringMethodRoadie.this.addFailure(new Exception(String.format("test timed out after %d milliseconds", timeout)));
                }
                catch (Exception e) {
                    SpringMethodRoadie.this.addFailure(e);
                }
            }
        });
    }

    protected void runTest() {
        this.runWithRepetitions(new Runnable(){

            public void run() {
                SpringMethodRoadie.this.runTestMethod();
            }
        });
    }

    protected void runWithRepetitions(Runnable test) {
        Method method = this.getTestMethod().getMethod();
        Repeat repeat = method.getAnnotation(Repeat.class);
        int runs = repeat != null && repeat.value() > 1 ? repeat.value() : 1;
        for (int i = 0; i < runs; ++i) {
            if (runs > 1 && logger != null && logger.isInfoEnabled()) {
                logger.info((Object)("Repetition " + (i + 1) + " of test " + method.getName()));
            }
            this.runBeforesThenTestThenAfters(test);
        }
    }

    protected void runBeforesThenTestThenAfters(Runnable test) {
        try {
            this.runBefores();
            test.run();
        }
        catch (FailedBefore e) {
        }
        catch (Exception e) {
            throw new RuntimeException("test should never throw an exception to this level");
        }
        finally {
            this.runAfters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTestMethod() {
        this.testException = null;
        try {
            this.getTestMethod().invoke(this.getTestInstance());
            if (this.getTestMethod().expectsException()) {
                this.addFailure((Throwable)((Object)new AssertionError((Object)("Expected exception: " + this.getTestMethod().getExpectedException().getName()))));
            }
        }
        catch (InvocationTargetException e) {
            this.testException = e.getTargetException();
            if (this.testException instanceof Assume.AssumptionViolatedException) {
                return;
            }
            if (!this.getTestMethod().expectsException()) {
                this.addFailure(this.testException);
            } else if (this.getTestMethod().isUnexpected(this.testException)) {
                String message = "Unexpected exception, expected<" + this.getTestMethod().getExpectedException().getName() + "> but was<" + this.testException.getClass().getName() + ">";
                this.addFailure(new Exception(message, this.testException));
            }
        }
        catch (Throwable t) {
            this.addFailure(t);
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Test method [" + this.getTestMethod().getMethod() + "] threw exception [" + this.testException + "]."));
            }
        }
    }

    protected void runBefores() throws FailedBefore {
        try {
            this.getTestContextManager().beforeTestMethod(this.getTestInstance(), this.getTestMethod().getMethod());
            List<Method> befores = this.getTestMethod().getBefores();
            for (Method before : befores) {
                before.invoke(this.getTestInstance(), new Object[0]);
            }
        }
        catch (InvocationTargetException e) {
            this.addFailure(e.getTargetException());
            throw new FailedBefore();
        }
        catch (Throwable t) {
            this.addFailure(t);
            throw new FailedBefore();
        }
    }

    protected void runAfters() {
        List<Method> afters = this.getTestMethod().getAfters();
        for (Method after : afters) {
            try {
                after.invoke(this.getTestInstance(), new Object[0]);
            }
            catch (InvocationTargetException e) {
                this.addFailure(e.getTargetException());
            }
            catch (Throwable t) {
                this.addFailure(t);
            }
        }
        try {
            this.getTestContextManager().afterTestMethod(this.getTestInstance(), this.getTestMethod().getMethod(), this.getTestException());
        }
        catch (Throwable t) {
            this.addFailure(t);
        }
    }

    protected void addFailure(Throwable exception) {
        this.getNotifier().fireTestFailure(new Failure(this.getDescription(), exception));
    }

    protected final TestContextManager getTestContextManager() {
        return this.testContextManager;
    }

    protected final Object getTestInstance() {
        return this.testInstance;
    }

    protected final SpringTestMethod getTestMethod() {
        return this.testMethod;
    }

    protected final Throwable getTestException() {
        return this.testException;
    }

    protected final RunNotifier getNotifier() {
        return this.notifier;
    }

    protected final Description getDescription() {
        return this.description;
    }

    protected final void setTestException(Throwable testException) {
        this.testException = testException;
    }

    private static class FailedBefore
    extends Exception {
        private static final long serialVersionUID = 8054300181079811763L;

        private FailedBefore() {
        }
    }
}

