/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.jdbc;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.util.StringUtils;

public abstract class SimpleJdbcTestUtils {
    private static final Log logger = LogFactory.getLog(SimpleJdbcTestUtils.class);

    public static final int countRowsInTable(SimpleJdbcTemplate simpleJdbcTemplate, String tableName) {
        return simpleJdbcTemplate.queryForInt("SELECT COUNT(0) FROM " + tableName, new Object[0]);
    }

    public static final int deleteFromTables(SimpleJdbcTemplate simpleJdbcTemplate, String ... tableNames) {
        int totalRowCount = 0;
        for (int i = 0; i < tableNames.length; ++i) {
            int rowCount = simpleJdbcTemplate.update("DELETE FROM " + tableNames[i], new Object[0]);
            totalRowCount += rowCount;
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("Deleted " + rowCount + " rows from table " + tableNames[i]));
        }
        return totalRowCount;
    }

    public static final void executeSqlScript(SimpleJdbcTemplate simpleJdbcTemplate, ResourceLoader resourceLoader, String sqlResourcePath, boolean continueOnError) throws DataAccessException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Executing SQL script '" + sqlResourcePath + "'"));
        }
        long startTime = System.currentTimeMillis();
        LinkedList<String> statements = new LinkedList<String>();
        Resource res = resourceLoader.getResource(sqlResourcePath);
        try {
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(res.getInputStream()));
            String currentStatement = lnr.readLine();
            while (currentStatement != null) {
                currentStatement = StringUtils.replace((String)currentStatement, (String)";", (String)"");
                statements.add(currentStatement);
                currentStatement = lnr.readLine();
            }
            for (String statement : statements) {
                try {
                    int rowsAffected = simpleJdbcTemplate.update(statement, new Object[0]);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)(rowsAffected + " rows affected by SQL: " + statement));
                }
                catch (DataAccessException ex) {
                    if (continueOnError) {
                        if (!logger.isWarnEnabled()) continue;
                        logger.warn((Object)("SQL: " + statement + " failed"), (Throwable)ex);
                        continue;
                    }
                    throw ex;
                }
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Done executing SQL script '" + sqlResourcePath + "' in " + elapsedTime + " ms."));
            }
        }
        catch (IOException ex) {
            throw new DataAccessResourceFailureException("Failed to open SQL script '" + sqlResourcePath + "'.", (Throwable)ex);
        }
    }
}

