/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.MatcherAssertionErrors;
import org.springframework.util.xml.SimpleNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpathExpectationsHelper {
    private final String expression;
    private final XPathExpression xpathExpression;

    public XpathExpectationsHelper(String expression, Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        this.expression = String.format(expression, args);
        this.xpathExpression = this.compileXpathExpression(this.expression, namespaces);
    }

    private XPathExpression compileXpathExpression(String expression, Map<String, String> namespaces) throws XPathExpressionException {
        SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
        namespaceContext.setBindings(namespaces != null ? namespaces : Collections.emptyMap());
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext((NamespaceContext)namespaceContext);
        return xpath.compile(expression);
    }

    protected XPathExpression getXpathExpression() {
        return this.xpathExpression;
    }

    public void assertNode(String content, Matcher<? super Node> matcher) throws Exception {
        Document document = this.parseXmlString(content);
        Node node = this.evaluateXpath(document, XPathConstants.NODE, Node.class);
        MatcherAssertionErrors.assertThat("Xpath: " + this.expression, node, matcher);
    }

    protected Document parseXmlString(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(xml));
        Document document = documentBuilder.parse(inputSource);
        return document;
    }

    protected <T> T evaluateXpath(Document document, QName evaluationType, Class<T> expectedClass) throws XPathExpressionException {
        return (T)this.getXpathExpression().evaluate(document, evaluationType);
    }

    public void exists(String content) throws Exception {
        this.assertNode(content, (Matcher<? super Node>)Matchers.notNullValue());
    }

    public void doesNotExist(String content) throws Exception {
        this.assertNode(content, (Matcher<? super Node>)Matchers.nullValue());
    }

    public void assertNodeCount(String content, Matcher<Integer> matcher) throws Exception {
        Document document = this.parseXmlString(content);
        NodeList nodeList = this.evaluateXpath(document, XPathConstants.NODESET, NodeList.class);
        String reason = "nodeCount Xpath: " + this.expression;
        MatcherAssertionErrors.assertThat(reason, nodeList.getLength(), matcher);
    }

    public void assertNodeCount(String content, int expectedCount) throws Exception {
        this.assertNodeCount(content, (Matcher<Integer>)Matchers.equalTo((Object)expectedCount));
    }

    public void assertString(String content, Matcher<? super String> matcher) throws Exception {
        Document document = this.parseXmlString(content);
        String result = this.evaluateXpath(document, XPathConstants.STRING, String.class);
        MatcherAssertionErrors.assertThat("Xpath: " + this.expression, result, matcher);
    }

    public void assertString(String content, String expectedValue) throws Exception {
        this.assertString(content, (Matcher<? super String>)Matchers.equalTo((Object)expectedValue));
    }

    public void assertNumber(String content, Matcher<? super Double> matcher) throws Exception {
        Document document = this.parseXmlString(content);
        Double result = this.evaluateXpath(document, XPathConstants.NUMBER, Double.class);
        MatcherAssertionErrors.assertThat("Xpath: " + this.expression, result, matcher);
    }

    public void assertNumber(String content, Double expectedValue) throws Exception {
        this.assertNumber(content, (Matcher<? super Double>)Matchers.equalTo((Object)expectedValue));
    }

    public void assertBoolean(String content, boolean expectedValue) throws Exception {
        Document document = this.parseXmlString(content);
        String result = this.evaluateXpath(document, XPathConstants.STRING, String.class);
        AssertionErrors.assertEquals("Xpath:", expectedValue, Boolean.parseBoolean(result));
    }
}

