/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.springframework.test.util.JsonPathExpectationsHelper;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonPathResultMatchers {
    private JsonPathExpectationsHelper jsonPathHelper;

    protected JsonPathResultMatchers(String expression, Object ... args) {
        this.jsonPathHelper = new JsonPathExpectationsHelper(expression, args);
    }

    public <T> ResultMatcher value(final Matcher<T> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                JsonPathResultMatchers.this.jsonPathHelper.assertValue(content, matcher);
            }
        };
    }

    public ResultMatcher value(Object value) {
        return this.value(Matchers.equalTo((Object)value));
    }

    public ResultMatcher exists() {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                JsonPathResultMatchers.this.jsonPathHelper.exists(content);
            }
        };
    }

    public ResultMatcher doesNotExist() {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                JsonPathResultMatchers.this.jsonPathHelper.doesNotExist(content);
            }
        };
    }

    public ResultMatcher isArray() {
        return this.value(Matchers.instanceOf(List.class));
    }
}

