/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.hamcrest.Matcher;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.MatcherAssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

public class HeaderResultMatchers {
    protected HeaderResultMatchers() {
    }

    public ResultMatcher string(final String name, final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                MatcherAssertionErrors.assertThat("Response header " + name, result.getResponse().getHeader(name), matcher);
            }
        };
    }

    public ResultMatcher string(final String name, final String value) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                AssertionErrors.assertEquals("Response header " + name, value, result.getResponse().getHeader(name));
            }
        };
    }

    public ResultMatcher longValue(final String name, final long value) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                AssertionErrors.assertTrue("Response does not contain header " + name, result.getResponse().containsHeader(name));
                AssertionErrors.assertEquals("Response header " + name, value, Long.parseLong(result.getResponse().getHeader(name)));
            }
        };
    }
}

