/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractTestContextBootstrapper;
import org.springframework.test.context.support.DelegatingSmartContextLoader;

public class DefaultTestContextBootstrapper
extends AbstractTestContextBootstrapper {
    private static final List<String> DEFAULT_TEST_EXECUTION_LISTENER_CLASS_NAMES = Collections.unmodifiableList(Arrays.asList("org.springframework.test.context.support.DependencyInjectionTestExecutionListener", "org.springframework.test.context.support.DirtiesContextTestExecutionListener", "org.springframework.test.context.transaction.TransactionalTestExecutionListener", "org.springframework.test.context.jdbc.SqlScriptsTestExecutionListener"));

    @Override
    protected List<String> getDefaultTestExecutionListenerClassNames() {
        return DEFAULT_TEST_EXECUTION_LISTENER_CLASS_NAMES;
    }

    @Override
    protected Class<? extends ContextLoader> getDefaultContextLoaderClass(Class<?> testClass) {
        return DelegatingSmartContextLoader.class;
    }

    @Override
    protected MergedContextConfiguration buildMergedContextConfiguration(Class<?> testClass, String[] locations, Class<?>[] classes, Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> initializerClasses, String[] activeProfiles, ContextLoader contextLoader, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, MergedContextConfiguration parentConfig) {
        return new MergedContextConfiguration(testClass, locations, classes, initializerClasses, activeProfiles, contextLoader, cacheAwareContextLoaderDelegate, parentConfig);
    }
}

