/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.DefaultTestContextBootstrapper;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.context.web.WebDelegatingSmartContextLoader;
import org.springframework.test.context.web.WebMergedContextConfiguration;

public class WebTestContextBootstrapper
extends DefaultTestContextBootstrapper {
    @Override
    protected List<String> getDefaultTestExecutionListenerClassNames() {
        ArrayList<String> classNames = new ArrayList<String>(super.getDefaultTestExecutionListenerClassNames());
        classNames.add(0, "org.springframework.test.context.web.ServletTestExecutionListener");
        return Collections.unmodifiableList(classNames);
    }

    @Override
    protected Class<? extends ContextLoader> getDefaultContextLoaderClass(Class<?> testClass) {
        if (AnnotationUtils.findAnnotation(testClass, WebAppConfiguration.class) != null) {
            return WebDelegatingSmartContextLoader.class;
        }
        return super.getDefaultContextLoaderClass(testClass);
    }

    @Override
    protected MergedContextConfiguration buildMergedContextConfiguration(Class<?> testClass, String[] locations, Class<?>[] classes, Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> initializerClasses, String[] activeProfiles, ContextLoader contextLoader, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, MergedContextConfiguration parentConfig) {
        WebAppConfiguration webAppConfiguration = (WebAppConfiguration)AnnotationUtils.findAnnotation(testClass, WebAppConfiguration.class);
        if (webAppConfiguration != null) {
            String resourceBasePath = webAppConfiguration.value();
            return new WebMergedContextConfiguration(testClass, locations, classes, initializerClasses, activeProfiles, resourceBasePath, contextLoader, cacheAwareContextLoaderDelegate, parentConfig);
        }
        return super.buildMergedContextConfiguration(testClass, locations, classes, initializerClasses, activeProfiles, contextLoader, cacheAwareContextLoaderDelegate, parentConfig);
    }
}

