/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.annotation.Repeat;
import org.springframework.test.annotation.Timed;

public class TestAnnotationUtils {
    public static long getTimeout(Method method) {
        AnnotationAttributes attributes = AnnotatedElementUtils.findAnnotationAttributes((AnnotatedElement)method, (String)Timed.class.getName());
        if (attributes == null) {
            return 0L;
        }
        long millis = (Long)attributes.getNumber("millis");
        return Math.max(0L, millis);
    }

    public static int getRepeatCount(Method method) {
        Repeat repeat = (Repeat)AnnotationUtils.findAnnotation((Method)method, Repeat.class);
        if (repeat == null) {
            return 1;
        }
        return Math.max(1, repeat.value());
    }
}

