/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.server.reactive;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MockServerHttpResponse
implements ServerHttpResponse {
    private HttpStatus status;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, ResponseCookie> cookies = new LinkedMultiValueMap();
    private Publisher<DataBuffer> body;
    private Publisher<Publisher<DataBuffer>> bodyWithFlushes;
    private DataBufferFactory bufferFactory = new DefaultDataBufferFactory();

    public boolean setStatusCode(HttpStatus status) {
        this.status = status;
        return true;
    }

    public HttpStatus getStatusCode() {
        return this.status;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public MultiValueMap<String, ResponseCookie> getCookies() {
        return this.cookies;
    }

    public Publisher<DataBuffer> getBody() {
        return this.body;
    }

    public Publisher<Publisher<DataBuffer>> getBodyWithFlush() {
        return this.bodyWithFlushes;
    }

    public Mono<Void> writeWith(Publisher<DataBuffer> body) {
        this.body = body;
        return Flux.from(this.body).then();
    }

    public Mono<Void> writeAndFlushWith(Publisher<Publisher<DataBuffer>> body) {
        this.bodyWithFlushes = body;
        return Flux.from(this.bodyWithFlushes).then();
    }

    public void beforeCommit(Supplier<? extends Mono<Void>> action) {
    }

    public Mono<Void> setComplete() {
        return Mono.empty();
    }

    public DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    public Mono<String> getBodyAsString() {
        Charset charset = this.getCharset();
        Charset charsetToUse = charset != null ? charset : StandardCharsets.UTF_8;
        return Flux.from(this.body).reduce((Object)this.bufferFactory.allocateBuffer(), (previous, current) -> {
            previous.write(new DataBuffer[]{current});
            DataBufferUtils.release((DataBuffer)current);
            return previous;
        }).map(buffer -> MockServerHttpResponse.dumpString(buffer, charsetToUse));
    }

    private static String dumpString(DataBuffer buffer, Charset charset) {
        Assert.notNull((Object)charset, (String)"'charset' must not be null");
        byte[] bytes = MockServerHttpResponse.dumpBytes(buffer);
        return new String(bytes, charset);
    }

    private static byte[] dumpBytes(DataBuffer buffer) {
        Assert.notNull((Object)buffer, (String)"'buffer' must not be null");
        byte[] bytes = new byte[buffer.readableByteCount()];
        buffer.read(bytes);
        return bytes;
    }

    private Charset getCharset() {
        MediaType contentType = this.getHeaders().getContentType();
        if (contentType != null) {
            return contentType.getCharset();
        }
        return null;
    }
}

