/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.io.IOException;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.util.XpathExpectationsHelper;
import org.springframework.test.web.client.RequestMatcher;
import org.w3c.dom.Node;

public class XpathRequestMatchers {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private final XpathExpectationsHelper xpathHelper;

    protected XpathRequestMatchers(String expression, Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        this.xpathHelper = new XpathExpectationsHelper(expression, namespaces, args);
    }

    public <T> RequestMatcher node(final Matcher<? super Node> matcher) {
        return new AbstractXpathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                XpathRequestMatchers.this.xpathHelper.assertNode(request.getBodyAsBytes(), XpathRequestMatchers.DEFAULT_ENCODING, (Matcher<? super Node>)matcher);
            }
        };
    }

    public <T> RequestMatcher exists() {
        return new AbstractXpathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                XpathRequestMatchers.this.xpathHelper.exists(request.getBodyAsBytes(), XpathRequestMatchers.DEFAULT_ENCODING);
            }
        };
    }

    public <T> RequestMatcher doesNotExist() {
        return new AbstractXpathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                XpathRequestMatchers.this.xpathHelper.doesNotExist(request.getBodyAsBytes(), XpathRequestMatchers.DEFAULT_ENCODING);
            }
        };
    }

    public <T> RequestMatcher nodeCount(final Matcher<Integer> matcher) {
        return new AbstractXpathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                XpathRequestMatchers.this.xpathHelper.assertNodeCount(request.getBodyAsBytes(), XpathRequestMatchers.DEFAULT_ENCODING, (Matcher<Integer>)matcher);
            }
        };
    }

    public <T> RequestMatcher nodeCount(final int expectedCount) {
        return new AbstractXpathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                XpathRequestMatchers.this.xpathHelper.assertNodeCount(request.getBodyAsBytes(), XpathRequestMatchers.DEFAULT_ENCODING, expectedCount);
            }
        };
    }

    public <T> RequestMatcher string(final Matcher<? super String> matcher) {
        return new AbstractXpathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                XpathRequestMatchers.this.xpathHelper.assertString(request.getBodyAsBytes(), XpathRequestMatchers.DEFAULT_ENCODING, (Matcher<? super String>)matcher);
            }
        };
    }

    public RequestMatcher string(final String value) {
        return new AbstractXpathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                XpathRequestMatchers.this.xpathHelper.assertString(request.getBodyAsBytes(), XpathRequestMatchers.DEFAULT_ENCODING, value);
            }
        };
    }

    public <T> RequestMatcher number(final Matcher<? super Double> matcher) {
        return new AbstractXpathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                XpathRequestMatchers.this.xpathHelper.assertNumber(request.getBodyAsBytes(), XpathRequestMatchers.DEFAULT_ENCODING, (Matcher<? super Double>)matcher);
            }
        };
    }

    public RequestMatcher number(final Double value) {
        return new AbstractXpathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                XpathRequestMatchers.this.xpathHelper.assertNumber(request.getBodyAsBytes(), XpathRequestMatchers.DEFAULT_ENCODING, value);
            }
        };
    }

    public <T> RequestMatcher booleanValue(final Boolean value) {
        return new AbstractXpathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                XpathRequestMatchers.this.xpathHelper.assertBoolean(request.getBodyAsBytes(), XpathRequestMatchers.DEFAULT_ENCODING, value);
            }
        };
    }

    private static abstract class AbstractXpathRequestMatcher
    implements RequestMatcher {
        private AbstractXpathRequestMatcher() {
        }

        @Override
        public final void match(ClientHttpRequest request) throws IOException, AssertionError {
            try {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
                this.matchInternal(mockRequest);
            }
            catch (Exception ex) {
                throw new AssertionError("Failed to parse XML request content", ex);
            }
        }

        protected abstract void matchInternal(MockClientHttpRequest var1) throws Exception;
    }
}

