/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.mock.jndi.SimpleNamingContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class SimpleNamingContextBuilder
implements InitialContextFactoryBuilder {
    private static volatile SimpleNamingContextBuilder activated;
    private static boolean initialized;
    private static final Object initializationLock;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Hashtable<String, Object> boundObjects = new Hashtable();

    @Nullable
    public static SimpleNamingContextBuilder getCurrentContextBuilder() {
        return activated;
    }

    public static SimpleNamingContextBuilder emptyActivatedContextBuilder() throws NamingException {
        if (activated != null) {
            activated.clear();
        } else {
            SimpleNamingContextBuilder builder = new SimpleNamingContextBuilder();
            builder.activate();
        }
        return activated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() throws IllegalStateException, NamingException {
        this.logger.info((Object)"Activating simple JNDI environment");
        Object object = initializationLock;
        synchronized (object) {
            if (!initialized) {
                Assert.state((!NamingManager.hasInitialContextFactoryBuilder() ? 1 : 0) != 0, (String)"Cannot activate SimpleNamingContextBuilder: there is already a JNDI provider registered. Note that JNDI is a JVM-wide service, shared at the JVM system class loader level, with no reset option. As a consequence, a JNDI provider must only be registered once per JVM.");
                NamingManager.setInitialContextFactoryBuilder(this);
                initialized = true;
            }
        }
        activated = this;
    }

    public void deactivate() {
        this.logger.info((Object)"Deactivating simple JNDI environment");
        activated = null;
    }

    public void clear() {
        this.boundObjects.clear();
    }

    public void bind(String name, Object obj) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Static JNDI binding: [" + name + "] = [" + obj + "]"));
        }
        this.boundObjects.put(name, obj);
    }

    @Override
    public InitialContextFactory createInitialContextFactory(@Nullable Hashtable<?, ?> environment) {
        Object icf;
        if (activated == null && environment != null && (icf = environment.get("java.naming.factory.initial")) != null) {
            Class icfClass;
            if (icf instanceof Class) {
                icfClass = (Class)icf;
            } else if (icf instanceof String) {
                icfClass = ClassUtils.resolveClassName((String)((String)icf), (ClassLoader)this.getClass().getClassLoader());
            } else {
                throw new IllegalArgumentException("Invalid value type for environment key [java.naming.factory.initial]: " + icf.getClass().getName());
            }
            if (!InitialContextFactory.class.isAssignableFrom(icfClass)) {
                throw new IllegalArgumentException("Specified class does not implement [" + InitialContextFactory.class.getName() + "]: " + icf);
            }
            try {
                return (InitialContextFactory)ReflectionUtils.accessibleConstructor((Class)icfClass, (Class[])new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Unable to instantiate specified InitialContextFactory: " + icf, ex);
            }
        }
        return new InitialContextFactory(){

            @Override
            public Context getInitialContext(Hashtable<?, ?> environment) {
                return new SimpleNamingContext("", SimpleNamingContextBuilder.this.boundObjects, environment);
            }
        };
    }

    static {
        initialized = false;
        initializationLock = new Object();
    }
}

