/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.springframework.lang.Nullable;
import org.springframework.test.annotation.ProfileValueUtils;
import org.springframework.test.annotation.TestAnnotationUtils;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit4.rules.SpringClassRule;
import org.springframework.test.context.junit4.rules.SpringMethodRule;
import org.springframework.test.context.junit4.statements.RunAfterTestClassCallbacks;
import org.springframework.test.context.junit4.statements.RunAfterTestExecutionCallbacks;
import org.springframework.test.context.junit4.statements.RunAfterTestMethodCallbacks;
import org.springframework.test.context.junit4.statements.RunBeforeTestClassCallbacks;
import org.springframework.test.context.junit4.statements.RunBeforeTestExecutionCallbacks;
import org.springframework.test.context.junit4.statements.RunBeforeTestMethodCallbacks;
import org.springframework.test.context.junit4.statements.SpringFailOnTimeout;
import org.springframework.test.context.junit4.statements.SpringRepeat;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class SpringJUnit4ClassRunner
extends BlockJUnit4ClassRunner {
    private static final Log logger = LogFactory.getLog(SpringJUnit4ClassRunner.class);
    private static final Method withRulesMethod;
    private final TestContextManager testContextManager;

    private static void ensureSpringRulesAreNotPresent(Class<?> testClass) {
        for (Field field : testClass.getFields()) {
            Assert.state((!SpringClassRule.class.isAssignableFrom(field.getType()) ? 1 : 0) != 0, () -> String.format("Detected SpringClassRule field in test class [%s], but SpringClassRule cannot be used with the SpringJUnit4ClassRunner.", testClass.getName()));
            Assert.state((!SpringMethodRule.class.isAssignableFrom(field.getType()) ? 1 : 0) != 0, () -> String.format("Detected SpringMethodRule field in test class [%s], but SpringMethodRule cannot be used with the SpringJUnit4ClassRunner.", testClass.getName()));
        }
    }

    public SpringJUnit4ClassRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SpringJUnit4ClassRunner constructor called with [" + clazz + "]"));
        }
        SpringJUnit4ClassRunner.ensureSpringRulesAreNotPresent(clazz);
        this.testContextManager = this.createTestContextManager(clazz);
    }

    protected TestContextManager createTestContextManager(Class<?> clazz) {
        return new TestContextManager(clazz);
    }

    protected final TestContextManager getTestContextManager() {
        return this.testContextManager;
    }

    public Description getDescription() {
        if (!ProfileValueUtils.isTestEnabledInThisEnvironment(this.getTestClass().getJavaClass())) {
            return Description.createSuiteDescription((Class)this.getTestClass().getJavaClass());
        }
        return super.getDescription();
    }

    public void run(RunNotifier notifier) {
        if (!ProfileValueUtils.isTestEnabledInThisEnvironment(this.getTestClass().getJavaClass())) {
            notifier.fireTestIgnored(this.getDescription());
            return;
        }
        super.run(notifier);
    }

    protected Statement withBeforeClasses(Statement statement) {
        Statement junitBeforeClasses = super.withBeforeClasses(statement);
        return new RunBeforeTestClassCallbacks(junitBeforeClasses, this.getTestContextManager());
    }

    protected Statement withAfterClasses(Statement statement) {
        Statement junitAfterClasses = super.withAfterClasses(statement);
        return new RunAfterTestClassCallbacks(junitAfterClasses, this.getTestContextManager());
    }

    protected Object createTest() throws Exception {
        Object testInstance = super.createTest();
        this.getTestContextManager().prepareTestInstance(testInstance);
        return testInstance;
    }

    protected void runChild(FrameworkMethod frameworkMethod, RunNotifier notifier) {
        Description description = this.describeChild(frameworkMethod);
        if (this.isTestMethodIgnored(frameworkMethod)) {
            notifier.fireTestIgnored(description);
        } else {
            Statement statement;
            try {
                statement = this.methodBlock(frameworkMethod);
            }
            catch (Throwable ex) {
                statement = new Fail(ex);
            }
            this.runLeaf(statement, description, notifier);
        }
    }

    protected Statement methodBlock(FrameworkMethod frameworkMethod) {
        Object testInstance;
        try {
            testInstance = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return SpringJUnit4ClassRunner.this.createTest();
                }
            }.run();
        }
        catch (Throwable ex) {
            return new Fail(ex);
        }
        Statement statement = this.methodInvoker(frameworkMethod, testInstance);
        statement = this.withBeforeTestExecutionCallbacks(frameworkMethod, testInstance, statement);
        statement = this.withAfterTestExecutionCallbacks(frameworkMethod, testInstance, statement);
        statement = this.possiblyExpectingExceptions(frameworkMethod, testInstance, statement);
        statement = this.withBefores(frameworkMethod, testInstance, statement);
        statement = this.withAfters(frameworkMethod, testInstance, statement);
        statement = this.withRulesReflectively(frameworkMethod, testInstance, statement);
        statement = this.withPotentialRepeat(frameworkMethod, testInstance, statement);
        statement = this.withPotentialTimeout(frameworkMethod, testInstance, statement);
        return statement;
    }

    private Statement withRulesReflectively(FrameworkMethod frameworkMethod, Object testInstance, Statement statement) {
        Object result = ReflectionUtils.invokeMethod((Method)withRulesMethod, (Object)((Object)this), (Object[])new Object[]{frameworkMethod, testInstance, statement});
        Assert.state((boolean)(result instanceof Statement), (String)"withRules mismatch");
        return (Statement)result;
    }

    protected boolean isTestMethodIgnored(FrameworkMethod frameworkMethod) {
        Method method = frameworkMethod.getMethod();
        return method.isAnnotationPresent(Ignore.class) || !ProfileValueUtils.isTestEnabledInThisEnvironment(method, this.getTestClass().getJavaClass());
    }

    protected Statement possiblyExpectingExceptions(FrameworkMethod frameworkMethod, Object testInstance, Statement next) {
        Class<? extends Throwable> expectedException = this.getExpectedException(frameworkMethod);
        return expectedException != null ? new ExpectException(next, expectedException) : next;
    }

    @Nullable
    protected Class<? extends Throwable> getExpectedException(FrameworkMethod frameworkMethod) {
        Test test = (Test)frameworkMethod.getAnnotation(Test.class);
        return test != null && test.expected() != Test.None.class ? test.expected() : null;
    }

    protected Statement withPotentialTimeout(FrameworkMethod frameworkMethod, Object testInstance, Statement next) {
        Object statement = null;
        long springTimeout = this.getSpringTimeout(frameworkMethod);
        long junitTimeout = this.getJUnitTimeout(frameworkMethod);
        if (springTimeout > 0L && junitTimeout > 0L) {
            String msg = String.format("Test method [%s] has been configured with Spring's @Timed(millis=%s) and JUnit's @Test(timeout=%s) annotations, but only one declaration of a 'timeout' is permitted per test method.", frameworkMethod.getMethod(), springTimeout, junitTimeout);
            logger.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        statement = springTimeout > 0L ? new SpringFailOnTimeout(next, springTimeout) : (junitTimeout > 0L ? FailOnTimeout.builder().withTimeout(junitTimeout, TimeUnit.MILLISECONDS).build(next) : next);
        return statement;
    }

    protected long getJUnitTimeout(FrameworkMethod frameworkMethod) {
        Test test = (Test)frameworkMethod.getAnnotation(Test.class);
        return test != null && test.timeout() > 0L ? test.timeout() : 0L;
    }

    protected long getSpringTimeout(FrameworkMethod frameworkMethod) {
        return TestAnnotationUtils.getTimeout(frameworkMethod.getMethod());
    }

    protected Statement withBeforeTestExecutionCallbacks(FrameworkMethod frameworkMethod, Object testInstance, Statement statement) {
        return new RunBeforeTestExecutionCallbacks(statement, testInstance, frameworkMethod.getMethod(), this.getTestContextManager());
    }

    protected Statement withAfterTestExecutionCallbacks(FrameworkMethod frameworkMethod, Object testInstance, Statement statement) {
        return new RunAfterTestExecutionCallbacks(statement, testInstance, frameworkMethod.getMethod(), this.getTestContextManager());
    }

    protected Statement withBefores(FrameworkMethod frameworkMethod, Object testInstance, Statement statement) {
        Statement junitBefores = super.withBefores(frameworkMethod, testInstance, statement);
        return new RunBeforeTestMethodCallbacks(junitBefores, testInstance, frameworkMethod.getMethod(), this.getTestContextManager());
    }

    protected Statement withAfters(FrameworkMethod frameworkMethod, Object testInstance, Statement statement) {
        Statement junitAfters = super.withAfters(frameworkMethod, testInstance, statement);
        return new RunAfterTestMethodCallbacks(junitAfters, testInstance, frameworkMethod.getMethod(), this.getTestContextManager());
    }

    protected Statement withPotentialRepeat(FrameworkMethod frameworkMethod, Object testInstance, Statement next) {
        return new SpringRepeat(next, frameworkMethod.getMethod());
    }

    static {
        Assert.state((boolean)ClassUtils.isPresent((String)"org.junit.internal.Throwables", (ClassLoader)SpringJUnit4ClassRunner.class.getClassLoader()), (String)"SpringJUnit4ClassRunner requires JUnit 4.12 or higher.");
        withRulesMethod = ReflectionUtils.findMethod(SpringJUnit4ClassRunner.class, (String)"withRules", (Class[])new Class[]{FrameworkMethod.class, Object.class, Statement.class});
        Assert.state((withRulesMethod != null ? 1 : 0) != 0, (String)"SpringJUnit4ClassRunner requires JUnit 4.12 or higher");
        ReflectionUtils.makeAccessible((Method)withRulesMethod);
    }
}

