/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet;

import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;

class DefaultMvcResult
implements MvcResult {
    private static final Object RESULT_NONE = new Object();
    private final MockHttpServletRequest mockRequest;
    private final MockHttpServletResponse mockResponse;
    private Object handler;
    private HandlerInterceptor[] interceptors;
    private ModelAndView modelAndView;
    private Exception resolvedException;
    private final AtomicReference<Object> asyncResult = new AtomicReference<Object>(RESULT_NONE);

    public DefaultMvcResult(MockHttpServletRequest request, MockHttpServletResponse response) {
        this.mockRequest = request;
        this.mockResponse = response;
    }

    @Override
    public MockHttpServletRequest getRequest() {
        return this.mockRequest;
    }

    @Override
    public MockHttpServletResponse getResponse() {
        return this.mockResponse;
    }

    public void setHandler(@Nullable Object handler) {
        this.handler = handler;
    }

    @Override
    public Object getHandler() {
        return this.handler;
    }

    public void setInterceptors(HandlerInterceptor ... interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public HandlerInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public void setResolvedException(Exception resolvedException) {
        this.resolvedException = resolvedException;
    }

    @Override
    public Exception getResolvedException() {
        return this.resolvedException;
    }

    public void setModelAndView(@Nullable ModelAndView mav) {
        this.modelAndView = mav;
    }

    @Override
    public ModelAndView getModelAndView() {
        return this.modelAndView;
    }

    @Override
    public FlashMap getFlashMap() {
        return RequestContextUtils.getOutputFlashMap((HttpServletRequest)this.mockRequest);
    }

    public void setAsyncResult(Object asyncResult) {
        this.asyncResult.set(asyncResult);
    }

    @Override
    public Object getAsyncResult() {
        return this.getAsyncResult(-1L);
    }

    @Override
    public Object getAsyncResult(long timeToWait) {
        Object result;
        if (this.mockRequest.getAsyncContext() != null) {
            long l = timeToWait = timeToWait == -1L ? this.mockRequest.getAsyncContext().getTimeout() : timeToWait;
        }
        if (timeToWait > 0L) {
            long endTime = System.currentTimeMillis() + timeToWait;
            while (System.currentTimeMillis() < endTime && this.asyncResult.get() == RESULT_NONE) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    throw new IllegalStateException("Interrupted while waiting for async result to be set for handler [" + this.handler + "]", ex);
                }
            }
        }
        if ((result = this.asyncResult.get()) == RESULT_NONE) {
            throw new IllegalStateException("Async result for handler [" + this.handler + "] was not set during the specified timeToWait=" + timeToWait);
        }
        return result;
    }
}

