/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.config;

import org.springframework.beans.factory.parsing.ProblemCollector;
import org.springframework.context.config.AbstractFeatureSpecification;
import org.springframework.context.config.AdviceMode;
import org.springframework.context.config.FeatureSpecificationExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.config.TxAnnotationDrivenExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class TxAnnotationDriven
extends AbstractFeatureSpecification {
    static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";
    private static final Class<? extends FeatureSpecificationExecutor> EXECUTOR_TYPE = TxAnnotationDrivenExecutor.class;
    private Object txManager = null;
    private Object order = null;
    private Boolean proxyTargetClass = false;
    private Object mode = AdviceMode.PROXY;

    public TxAnnotationDriven() {
        this(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME);
    }

    public TxAnnotationDriven(String txManagerBeanName) {
        super(EXECUTOR_TYPE);
        this.txManager = txManagerBeanName != null ? txManagerBeanName : DEFAULT_TRANSACTION_MANAGER_BEAN_NAME;
    }

    public TxAnnotationDriven(PlatformTransactionManager txManager) {
        super(EXECUTOR_TYPE);
        Assert.notNull((Object)txManager, (String)"transaction manager must not be null");
        this.txManager = txManager;
    }

    Object transactionManager() {
        return this.txManager;
    }

    public TxAnnotationDriven mode(AdviceMode mode) {
        this.mode = mode;
        return this;
    }

    TxAnnotationDriven mode(String mode) {
        if (StringUtils.hasText((String)mode)) {
            this.mode = mode;
        }
        return this;
    }

    AdviceMode mode() {
        if (this.mode instanceof AdviceMode) {
            return (AdviceMode)this.mode;
        }
        if (this.mode instanceof String) {
            return (AdviceMode)ObjectUtils.caseInsensitiveValueOf((Enum[])AdviceMode.values(), (String)((String)this.mode));
        }
        throw new IllegalStateException("invalid type for field 'mode' (must be of type AdviceMode or String): " + this.mode.getClass().getName());
    }

    public TxAnnotationDriven proxyTargetClass(Boolean proxyTargetClass) {
        this.proxyTargetClass = proxyTargetClass;
        return this;
    }

    Boolean proxyTargetClass() {
        return this.proxyTargetClass;
    }

    public TxAnnotationDriven order(int order) {
        this.order = order;
        return this;
    }

    public TxAnnotationDriven order(String order) {
        if (StringUtils.hasText((String)order)) {
            this.order = order;
        }
        return this;
    }

    Object order() {
        return this.order;
    }

    protected void doValidate(ProblemCollector problems) {
        if (this.mode instanceof String && !ObjectUtils.containsConstant((Enum[])AdviceMode.values(), (String)((String)this.mode))) {
            problems.error("no such mode name: " + this.mode);
        }
    }
}

