/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.BindInitializer;
import org.springframework.web.bind.ServletRequestDataBinder;

public abstract class BindUtils {
    public static BindException bind(ServletRequest request, Object object, String objectName) {
        ServletRequestDataBinder binder = new ServletRequestDataBinder(object, objectName);
        binder.bind(request);
        return binder.getErrors();
    }

    public static BindException bind(ServletRequest request, Object object, String objectName, BindInitializer initializer) throws ServletException {
        ServletRequestDataBinder binder = new ServletRequestDataBinder(object, objectName);
        if (initializer != null) {
            initializer.initBinder(request, binder);
        }
        binder.bind(request);
        return binder.getErrors();
    }

    public static BindException bindAndValidate(ServletRequest request, Object object, String objectName, Validator validator) {
        BindException binder = BindUtils.bind(request, object, objectName);
        if (validator != null) {
            ValidationUtils.invokeValidator((Validator)validator, (Object)object, (Errors)binder);
        }
        return binder;
    }

    public static BindException bindAndValidate(ServletRequest request, Object object, String objectName, Validator validator, BindInitializer initializer) throws ServletException {
        BindException binder = BindUtils.bind(request, object, objectName, initializer);
        if (validator != null) {
            ValidationUtils.invokeValidator((Validator)validator, (Object)object, (Errors)binder);
        }
        return binder;
    }
}

