/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.caucho;

import com.caucho.burlap.io.BurlapInput;
import com.caucho.burlap.io.BurlapOutput;
import com.caucho.burlap.server.BurlapSkeleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.support.RemoteExporter;
import org.springframework.util.Assert;

public class BurlapExporter
extends RemoteExporter
implements InitializingBean {
    private BurlapSkeleton skeleton;

    public void afterPropertiesSet() {
        this.prepare();
    }

    public void prepare() {
        try {
            try {
                Constructor ctor = BurlapSkeleton.class.getConstructor(Object.class, Class.class);
                this.checkService();
                this.checkServiceInterface();
                this.skeleton = (BurlapSkeleton)ctor.newInstance(this.getProxyForService(), this.getServiceInterface());
            }
            catch (NoSuchMethodException ex) {
                Constructor ctor = BurlapSkeleton.class.getConstructor(Object.class);
                this.skeleton = (BurlapSkeleton)ctor.newInstance(this.getProxyForService());
            }
        }
        catch (Exception ex) {
            throw new BeanInitializationException("Burlap skeleton initialization failed", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(InputStream inputStream, OutputStream outputStream) throws Throwable {
        Assert.notNull((Object)this.skeleton, (String)"Burlap exporter has not been initialized");
        ClassLoader originalClassLoader = this.overrideThreadContextClassLoader();
        try {
            this.skeleton.invoke(new BurlapInput(inputStream), new BurlapOutput(outputStream));
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ex) {}
            try {
                outputStream.close();
            }
            catch (IOException ex) {}
            this.resetThreadContextClassLoader(originalClassLoader);
        }
    }
}

