/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.xml;

import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXmlHttpMessageConverter<T>
extends AbstractHttpMessageConverter<T> {
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    protected AbstractXmlHttpMessageConverter() {
        super(new MediaType("application", "xml"), new MediaType("text", "xml"));
    }

    @Override
    public final T readInternal(Class<T> clazz, HttpInputMessage inputMessage) throws IOException {
        return this.readFromSource(clazz, inputMessage.getHeaders(), new StreamSource(inputMessage.getBody()));
    }

    protected abstract T readFromSource(Class<T> var1, HttpHeaders var2, Source var3) throws IOException;

    @Override
    protected final void writeInternal(T t, HttpOutputMessage outputMessage) throws IOException {
        this.writeToResult(t, outputMessage.getHeaders(), new StreamResult(outputMessage.getBody()));
    }

    protected abstract void writeToResult(T var1, HttpHeaders var2, Result var3) throws IOException;

    protected void transform(Source source, Result result) throws TransformerException {
        Transformer transformer = this.transformerFactory.newTransformer();
        transformer.transform(source, result);
    }
}

