/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.commons;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonsFileUploadSupport {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final DiskFileItemFactory fileItemFactory = this.newFileItemFactory();
    private final FileUpload fileUpload = this.newFileUpload((FileItemFactory)this.getFileItemFactory());
    private boolean uploadTempDirSpecified = false;

    public DiskFileItemFactory getFileItemFactory() {
        return this.fileItemFactory;
    }

    public FileUpload getFileUpload() {
        return this.fileUpload;
    }

    public void setMaxUploadSize(long maxUploadSize) {
        this.fileUpload.setSizeMax(maxUploadSize);
    }

    public void setMaxInMemorySize(int maxInMemorySize) {
        this.fileItemFactory.setSizeThreshold(maxInMemorySize);
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.fileUpload.setHeaderEncoding(defaultEncoding);
    }

    protected String getDefaultEncoding() {
        String encoding = this.getFileUpload().getHeaderEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        return encoding;
    }

    public void setUploadTempDir(Resource uploadTempDir) throws IOException {
        if (!uploadTempDir.exists() && !uploadTempDir.getFile().mkdirs()) {
            throw new IllegalArgumentException("Given uploadTempDir [" + uploadTempDir + "] could not be created");
        }
        this.fileItemFactory.setRepository(uploadTempDir.getFile());
        this.uploadTempDirSpecified = true;
    }

    protected boolean isUploadTempDirSpecified() {
        return this.uploadTempDirSpecified;
    }

    protected DiskFileItemFactory newFileItemFactory() {
        return new DiskFileItemFactory();
    }

    protected abstract FileUpload newFileUpload(FileItemFactory var1);

    protected FileUpload prepareFileUpload(String encoding) {
        FileUpload fileUpload;
        FileUpload actualFileUpload = fileUpload = this.getFileUpload();
        if (encoding != null && !encoding.equals(fileUpload.getHeaderEncoding())) {
            actualFileUpload = this.newFileUpload((FileItemFactory)this.getFileItemFactory());
            actualFileUpload.setSizeMax(fileUpload.getSizeMax());
            actualFileUpload.setHeaderEncoding(encoding);
        }
        return actualFileUpload;
    }

    protected MultipartParsingResult parseFileItems(List<FileItem> fileItems, String encoding) {
        HashMap<String, MultipartFile> multipartFiles = new HashMap<String, MultipartFile>();
        HashMap<String, String[]> multipartParameters = new HashMap<String, String[]>();
        for (FileItem fileItem : fileItems) {
            if (fileItem.isFormField()) {
                String[] curParam;
                String value = null;
                if (encoding != null) {
                    try {
                        value = fileItem.getString(encoding);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn((Object)("Could not decode multipart item '" + fileItem.getFieldName() + "' with encoding '" + encoding + "': using platform default"));
                        }
                        value = fileItem.getString();
                    }
                } else {
                    value = fileItem.getString();
                }
                if ((curParam = (String[])multipartParameters.get(fileItem.getFieldName())) == null) {
                    multipartParameters.put(fileItem.getFieldName(), new String[]{value});
                    continue;
                }
                String[] newParam = StringUtils.addStringToArray((String[])curParam, (String)value);
                multipartParameters.put(fileItem.getFieldName(), newParam);
                continue;
            }
            CommonsMultipartFile file = new CommonsMultipartFile(fileItem);
            if (multipartFiles.put(file.getName(), file) != null) {
                throw new MultipartException("Multiple files for field name [" + file.getName() + "] found - not supported by MultipartResolver");
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Found multipart file [" + file.getName() + "] of size " + file.getSize() + " bytes with original filename [" + file.getOriginalFilename() + "], stored " + file.getStorageDescription()));
        }
        return new MultipartParsingResult(multipartFiles, multipartParameters);
    }

    protected void cleanupFileItems(Collection<MultipartFile> multipartFiles) {
        for (MultipartFile file : multipartFiles) {
            if (!(file instanceof CommonsMultipartFile)) continue;
            CommonsMultipartFile cmf = (CommonsMultipartFile)file;
            cmf.getFileItem().delete();
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Cleaning up multipart file [" + cmf.getName() + "] with original filename [" + cmf.getOriginalFilename() + "], stored " + cmf.getStorageDescription()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MultipartParsingResult {
        private final Map<String, MultipartFile> multipartFiles;
        private final Map<String, String[]> multipartParameters;

        public MultipartParsingResult(Map<String, MultipartFile> mpFiles, Map<String, String[]> mpParams) {
            this.multipartFiles = mpFiles;
            this.multipartParameters = mpParams;
        }

        public Map<String, MultipartFile> getMultipartFiles() {
            return this.multipartFiles;
        }

        public Map<String, String[]> getMultipartParameters() {
            return this.multipartParameters;
        }
    }
}

