/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.context.request.WebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionAttributesHandler {
    private final Set<String> attributeNames = new HashSet<String>();
    private final Set<Class> attributeTypes = new HashSet<Class>();
    private final Set<String> resolvedAttributeNames = Collections.synchronizedSet(new HashSet(4));
    private final SessionAttributeStore attributeStore;

    public SessionAttributesHandler(Class<?> handlerType, SessionAttributeStore attributeStore) {
        Assert.notNull((Object)attributeStore, (String)"SessionAttributeStore may not be null.");
        this.attributeStore = attributeStore;
        SessionAttributes annotation = (SessionAttributes)AnnotationUtils.findAnnotation(handlerType, SessionAttributes.class);
        if (annotation != null) {
            this.attributeNames.addAll((Collection<String>)Arrays.asList(annotation.value()));
            this.attributeTypes.addAll((Collection<Class>)Arrays.asList(annotation.types()));
        }
    }

    public boolean hasSessionAttributes() {
        return this.attributeNames.size() > 0 || this.attributeTypes.size() > 0;
    }

    public boolean isHandlerSessionAttribute(String attributeName, Class<?> attributeType) {
        Assert.notNull((Object)attributeName, (String)"Attribute name must not be null");
        if (this.attributeNames.contains(attributeName) || this.attributeTypes.contains(attributeType)) {
            this.resolvedAttributeNames.add(attributeName);
            return true;
        }
        return false;
    }

    public Object retrieveAttribute(WebRequest request, String attributeName) {
        return this.attributeStore.retrieveAttribute(request, attributeName);
    }

    public Map<String, ?> retrieveHandlerSessionAttributes(WebRequest request) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (String name : this.resolvedAttributeNames) {
            Object value = this.attributeStore.retrieveAttribute(request, name);
            if (value == null) continue;
            attributes.put(name, value);
        }
        return attributes;
    }

    public void cleanupHandlerSessionAttributes(WebRequest request) {
        for (String attributeName : this.resolvedAttributeNames) {
            this.attributeStore.cleanupAttribute(request, attributeName);
        }
    }

    public void storeHandlerSessionAttributes(WebRequest request, Map<String, Object> attributes) {
        for (String name : attributes.keySet()) {
            Class<?> attrType;
            Object value = attributes.get(name);
            Class<?> clazz = attrType = value != null ? value.getClass() : null;
            if (!this.isHandlerSessionAttribute(name, attrType)) continue;
            this.attributeStore.storeAttribute(request, name, value);
        }
    }
}

