/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.AsyncClientHttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.client.support.AsyncHttpAccessor;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.client.AsyncRequestCallback;
import org.springframework.web.client.AsyncRestOperations;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;

public class AsyncRestTemplate
extends AsyncHttpAccessor
implements AsyncRestOperations {
    private final RestTemplate syncTemplate;

    public AsyncRestTemplate() {
        this((AsyncTaskExecutor)new SimpleAsyncTaskExecutor());
    }

    public AsyncRestTemplate(AsyncTaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"AsyncTaskExecutor must not be null");
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setTaskExecutor(taskExecutor);
        this.syncTemplate = new RestTemplate(requestFactory);
        this.setAsyncRequestFactory(requestFactory);
    }

    public AsyncRestTemplate(AsyncClientHttpRequestFactory asyncRequestFactory) {
        this(asyncRequestFactory, (ClientHttpRequestFactory)((Object)asyncRequestFactory));
    }

    public AsyncRestTemplate(AsyncClientHttpRequestFactory asyncRequestFactory, ClientHttpRequestFactory syncRequestFactory) {
        this(asyncRequestFactory, new RestTemplate(syncRequestFactory));
    }

    public AsyncRestTemplate(AsyncClientHttpRequestFactory requestFactory, RestTemplate restTemplate) {
        Assert.notNull((Object)restTemplate, (String)"'restTemplate' must not be null");
        this.syncTemplate = restTemplate;
        this.setAsyncRequestFactory(requestFactory);
    }

    public void setErrorHandler(ResponseErrorHandler errorHandler) {
        this.syncTemplate.setErrorHandler(errorHandler);
    }

    public ResponseErrorHandler getErrorHandler() {
        return this.syncTemplate.getErrorHandler();
    }

    @Override
    public RestOperations getRestOperations() {
        return this.syncTemplate;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.syncTemplate.setMessageConverters(messageConverters);
    }

    public List<HttpMessageConverter<?>> getMessageConverters() {
        return this.syncTemplate.getMessageConverters();
    }

    @Override
    public <T> Future<ResponseEntity<T>> getForEntity(String url, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        AsyncRequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return this.execute(url, HttpMethod.GET, requestCallback, responseExtractor, uriVariables);
    }

    @Override
    public <T> Future<ResponseEntity<T>> getForEntity(String url, Class<T> responseType, Map<String, ?> urlVariables) throws RestClientException {
        AsyncRequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return this.execute(url, HttpMethod.GET, requestCallback, responseExtractor, urlVariables);
    }

    @Override
    public <T> Future<ResponseEntity<T>> getForEntity(URI url, Class<T> responseType) throws RestClientException {
        AsyncRequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return this.execute(url, HttpMethod.GET, requestCallback, responseExtractor);
    }

    @Override
    public Future<HttpHeaders> headForHeaders(String url, Object ... uriVariables) throws RestClientException {
        ResponseExtractor<HttpHeaders> headersExtractor = this.headersExtractor();
        return this.execute(url, HttpMethod.HEAD, null, headersExtractor, uriVariables);
    }

    @Override
    public Future<HttpHeaders> headForHeaders(String url, Map<String, ?> uriVariables) throws RestClientException {
        ResponseExtractor<HttpHeaders> headersExtractor = this.headersExtractor();
        return this.execute(url, HttpMethod.HEAD, null, headersExtractor, uriVariables);
    }

    @Override
    public Future<HttpHeaders> headForHeaders(URI url) throws RestClientException {
        ResponseExtractor<HttpHeaders> headersExtractor = this.headersExtractor();
        return this.execute(url, HttpMethod.HEAD, null, headersExtractor);
    }

    @Override
    public Future<URI> postForLocation(String url, HttpEntity<?> request, Object ... uriVariables) throws RestClientException {
        AsyncRequestCallback requestCallback = this.httpEntityCallback(request);
        ResponseExtractor<HttpHeaders> headersExtractor = this.headersExtractor();
        Future<HttpHeaders> headersFuture = this.execute(url, HttpMethod.POST, requestCallback, headersExtractor, uriVariables);
        return AsyncRestTemplate.extractLocationHeader(headersFuture);
    }

    @Override
    public Future<URI> postForLocation(String url, HttpEntity<?> request, Map<String, ?> uriVariables) throws RestClientException {
        AsyncRequestCallback requestCallback = this.httpEntityCallback(request);
        ResponseExtractor<HttpHeaders> headersExtractor = this.headersExtractor();
        Future<HttpHeaders> headersFuture = this.execute(url, HttpMethod.POST, requestCallback, headersExtractor, uriVariables);
        return AsyncRestTemplate.extractLocationHeader(headersFuture);
    }

    @Override
    public Future<URI> postForLocation(URI url, HttpEntity<?> request) throws RestClientException {
        AsyncRequestCallback requestCallback = this.httpEntityCallback(request);
        ResponseExtractor<HttpHeaders> headersExtractor = this.headersExtractor();
        Future<HttpHeaders> headersFuture = this.execute(url, HttpMethod.POST, requestCallback, headersExtractor);
        return AsyncRestTemplate.extractLocationHeader(headersFuture);
    }

    private static Future<URI> extractLocationHeader(final Future<HttpHeaders> headersFuture) {
        return new Future<URI>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return headersFuture.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return headersFuture.isCancelled();
            }

            @Override
            public boolean isDone() {
                return headersFuture.isDone();
            }

            @Override
            public URI get() throws InterruptedException, ExecutionException {
                HttpHeaders headers = (HttpHeaders)headersFuture.get();
                return headers.getLocation();
            }

            @Override
            public URI get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                HttpHeaders headers = (HttpHeaders)headersFuture.get(timeout, unit);
                return headers.getLocation();
            }
        };
    }

    @Override
    public <T> Future<ResponseEntity<T>> postForEntity(String url, HttpEntity<?> request, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        AsyncRequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return this.execute(url, HttpMethod.POST, requestCallback, responseExtractor, uriVariables);
    }

    @Override
    public <T> Future<ResponseEntity<T>> postForEntity(String url, HttpEntity<?> request, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        AsyncRequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return this.execute(url, HttpMethod.POST, requestCallback, responseExtractor, uriVariables);
    }

    @Override
    public <T> Future<ResponseEntity<T>> postForEntity(URI url, HttpEntity<?> request, Class<T> responseType) throws RestClientException {
        AsyncRequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return this.execute(url, HttpMethod.POST, requestCallback, responseExtractor);
    }

    @Override
    public Future<Void> put(String url, HttpEntity<?> request, Object ... uriVariables) throws RestClientException {
        AsyncRequestCallback requestCallback = this.httpEntityCallback(request);
        return this.execute(url, HttpMethod.PUT, requestCallback, null, uriVariables);
    }

    @Override
    public Future<Void> put(String url, HttpEntity<?> request, Map<String, ?> uriVariables) throws RestClientException {
        AsyncRequestCallback requestCallback = this.httpEntityCallback(request);
        return this.execute(url, HttpMethod.PUT, requestCallback, null, uriVariables);
    }

    @Override
    public Future<Void> put(URI url, HttpEntity<?> request) throws RestClientException {
        AsyncRequestCallback requestCallback = this.httpEntityCallback(request);
        return this.execute(url, HttpMethod.PUT, requestCallback, null);
    }

    @Override
    public Future<Void> delete(String url, Object ... urlVariables) throws RestClientException {
        return this.execute(url, HttpMethod.DELETE, null, null, urlVariables);
    }

    @Override
    public Future<Void> delete(String url, Map<String, ?> urlVariables) throws RestClientException {
        return this.execute(url, HttpMethod.DELETE, null, null, urlVariables);
    }

    @Override
    public Future<Void> delete(URI url) throws RestClientException {
        return this.execute(url, HttpMethod.DELETE, null, null);
    }

    @Override
    public Future<Set<HttpMethod>> optionsForAllow(String url, Object ... uriVariables) throws RestClientException {
        ResponseExtractor<HttpHeaders> headersExtractor = this.headersExtractor();
        Future<HttpHeaders> headersFuture = this.execute(url, HttpMethod.OPTIONS, null, headersExtractor, uriVariables);
        return AsyncRestTemplate.extractAllowHeader(headersFuture);
    }

    @Override
    public Future<Set<HttpMethod>> optionsForAllow(String url, Map<String, ?> uriVariables) throws RestClientException {
        ResponseExtractor<HttpHeaders> headersExtractor = this.headersExtractor();
        Future<HttpHeaders> headersFuture = this.execute(url, HttpMethod.OPTIONS, null, headersExtractor, uriVariables);
        return AsyncRestTemplate.extractAllowHeader(headersFuture);
    }

    @Override
    public Future<Set<HttpMethod>> optionsForAllow(URI url) throws RestClientException {
        ResponseExtractor<HttpHeaders> headersExtractor = this.headersExtractor();
        Future<HttpHeaders> headersFuture = this.execute(url, HttpMethod.OPTIONS, null, headersExtractor);
        return AsyncRestTemplate.extractAllowHeader(headersFuture);
    }

    private static Future<Set<HttpMethod>> extractAllowHeader(final Future<HttpHeaders> headersFuture) {
        return new Future<Set<HttpMethod>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return headersFuture.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return headersFuture.isCancelled();
            }

            @Override
            public boolean isDone() {
                return headersFuture.isDone();
            }

            @Override
            public Set<HttpMethod> get() throws InterruptedException, ExecutionException {
                HttpHeaders headers = (HttpHeaders)headersFuture.get();
                return headers.getAllow();
            }

            @Override
            public Set<HttpMethod> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                HttpHeaders headers = (HttpHeaders)headersFuture.get(timeout, unit);
                return headers.getAllow();
            }
        };
    }

    @Override
    public <T> Future<ResponseEntity<T>> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        AsyncRequestCallback requestCallback = this.httpEntityCallback(requestEntity, responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return this.execute(url, method, requestCallback, responseExtractor, uriVariables);
    }

    @Override
    public <T> Future<ResponseEntity<T>> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        AsyncRequestCallback requestCallback = this.httpEntityCallback(requestEntity, responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return this.execute(url, method, requestCallback, responseExtractor, uriVariables);
    }

    @Override
    public <T> Future<ResponseEntity<T>> exchange(URI url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType) throws RestClientException {
        AsyncRequestCallback requestCallback = this.httpEntityCallback(requestEntity, responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return this.execute(url, method, requestCallback, responseExtractor);
    }

    @Override
    public <T> Future<ResponseEntity<T>> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Object ... uriVariables) throws RestClientException {
        Type type = responseType.getType();
        AsyncRequestCallback requestCallback = this.httpEntityCallback(requestEntity, type);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(type);
        return this.execute(url, method, requestCallback, responseExtractor, uriVariables);
    }

    @Override
    public <T> Future<ResponseEntity<T>> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        Type type = responseType.getType();
        AsyncRequestCallback requestCallback = this.httpEntityCallback(requestEntity, type);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(type);
        return this.execute(url, method, requestCallback, responseExtractor, uriVariables);
    }

    @Override
    public <T> Future<ResponseEntity<T>> exchange(URI url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType) throws RestClientException {
        Type type = responseType.getType();
        AsyncRequestCallback requestCallback = this.httpEntityCallback(requestEntity, type);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(type);
        return this.execute(url, method, requestCallback, responseExtractor);
    }

    @Override
    public <T> Future<T> execute(String url, HttpMethod method, AsyncRequestCallback requestCallback, ResponseExtractor<T> responseExtractor, Object ... urlVariables) throws RestClientException {
        URI expanded = new UriTemplate(url).expand(urlVariables);
        return this.doExecute(expanded, method, requestCallback, responseExtractor);
    }

    @Override
    public <T> Future<T> execute(String url, HttpMethod method, AsyncRequestCallback requestCallback, ResponseExtractor<T> responseExtractor, Map<String, ?> urlVariables) throws RestClientException {
        URI expanded = new UriTemplate(url).expand(urlVariables);
        return this.doExecute(expanded, method, requestCallback, responseExtractor);
    }

    @Override
    public <T> Future<T> execute(URI url, HttpMethod method, AsyncRequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        return this.doExecute(url, method, requestCallback, responseExtractor);
    }

    protected <T> Future<T> doExecute(URI url, HttpMethod method, AsyncRequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        Assert.notNull((Object)url, (String)"'url' must not be null");
        Assert.notNull((Object)((Object)method), (String)"'method' must not be null");
        try {
            AsyncClientHttpRequest request = this.createAsyncRequest(url, method);
            if (requestCallback != null) {
                requestCallback.doWithRequest(request);
            }
            Future<ClientHttpResponse> responseFuture = request.executeAsync();
            if (responseExtractor != null) {
                return new ResponseExtractorFuture<T>(method, url, responseFuture, responseExtractor);
            }
            return new VoidResponseFuture(method, url, responseFuture);
        }
        catch (IOException ex) {
            throw new ResourceAccessException("I/O error on " + method.name() + " request for \"" + url + "\":" + ex.getMessage(), ex);
        }
    }

    private void logResponseStatus(HttpMethod method, URI url, ClientHttpResponse response) {
        if (this.logger.isDebugEnabled()) {
            try {
                this.logger.debug((Object)("Async " + method.name() + " request for \"" + url + "\" resulted in " + (Object)((Object)response.getStatusCode()) + " (" + response.getStatusText() + ")"));
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    private void handleResponseError(HttpMethod method, URI url, ClientHttpResponse response) throws IOException {
        if (this.logger.isWarnEnabled()) {
            try {
                this.logger.warn((Object)("Async " + method.name() + " request for \"" + url + "\" resulted in " + (Object)((Object)response.getStatusCode()) + " (" + response.getStatusText() + "); invoking error handler"));
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        this.getErrorHandler().handleError(response);
    }

    protected <T> AsyncRequestCallback acceptHeaderRequestCallback(Class<T> responseType) {
        return new AsyncRequestCallbackAdapter(this.syncTemplate.acceptHeaderRequestCallback(responseType));
    }

    protected <T> AsyncRequestCallback httpEntityCallback(HttpEntity<T> requestBody) {
        return new AsyncRequestCallbackAdapter(this.syncTemplate.httpEntityCallback(requestBody));
    }

    protected <T> AsyncRequestCallback httpEntityCallback(HttpEntity<T> request, Type responseType) {
        return new AsyncRequestCallbackAdapter(this.syncTemplate.httpEntityCallback(request, responseType));
    }

    protected <T> ResponseExtractor<ResponseEntity<T>> responseEntityExtractor(Type responseType) {
        return this.syncTemplate.responseEntityExtractor(responseType);
    }

    protected ResponseExtractor<HttpHeaders> headersExtractor() {
        return this.syncTemplate.headersExtractor();
    }

    private static class AsyncRequestCallbackAdapter
    implements AsyncRequestCallback {
        private final RequestCallback adaptee;

        public AsyncRequestCallbackAdapter(RequestCallback requestCallback) {
            this.adaptee = requestCallback;
        }

        @Override
        public void doWithRequest(final AsyncClientHttpRequest request) throws IOException {
            if (this.adaptee != null) {
                this.adaptee.doWithRequest(new ClientHttpRequest(){

                    @Override
                    public ClientHttpResponse execute() throws IOException {
                        throw new UnsupportedOperationException("execute not supported");
                    }

                    @Override
                    public OutputStream getBody() throws IOException {
                        return request.getBody();
                    }

                    @Override
                    public HttpMethod getMethod() {
                        return request.getMethod();
                    }

                    @Override
                    public URI getURI() {
                        return request.getURI();
                    }

                    @Override
                    public HttpHeaders getHeaders() {
                        return request.getHeaders();
                    }
                });
            }
        }
    }

    private class VoidResponseFuture
    extends ResponseFuture<Void> {
        public VoidResponseFuture(HttpMethod method, URI url, Future<ClientHttpResponse> responseFuture) {
            super(method, url, responseFuture);
        }

        @Override
        protected Void extractData(ClientHttpResponse response) throws IOException {
            return null;
        }
    }

    private class ResponseExtractorFuture<T>
    extends ResponseFuture<T> {
        private final ResponseExtractor<T> responseExtractor;

        public ResponseExtractorFuture(HttpMethod method, URI url, Future<ClientHttpResponse> responseFuture, ResponseExtractor<T> responseExtractor) {
            super(method, url, responseFuture);
            this.responseExtractor = responseExtractor;
        }

        @Override
        protected T extractData(ClientHttpResponse response) throws IOException {
            return this.responseExtractor.extractData(response);
        }
    }

    private abstract class ResponseFuture<T>
    implements Future<T> {
        private final HttpMethod method;
        private final URI url;
        private final Future<ClientHttpResponse> responseFuture;

        public ResponseFuture(HttpMethod method, URI url, Future<ClientHttpResponse> responseFuture) {
            this.method = method;
            this.url = url;
            this.responseFuture = responseFuture;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.responseFuture.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.responseFuture.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.responseFuture.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.getInternal(this.responseFuture.get());
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.getInternal(this.responseFuture.get(timeout, unit));
        }

        private T getInternal(ClientHttpResponse response) throws ExecutionException {
            try {
                if (!AsyncRestTemplate.this.getErrorHandler().hasError(response)) {
                    AsyncRestTemplate.this.logResponseStatus(this.method, this.url, response);
                } else {
                    AsyncRestTemplate.this.handleResponseError(this.method, this.url, response);
                }
                T t = this.extractData(response);
                return t;
            }
            catch (IOException ex) {
                throw new ExecutionException(ex);
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }

        protected abstract T extractData(ClientHttpResponse var1) throws IOException;
    }
}

