/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.json;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.CodecException;
import org.springframework.core.codec.Decoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.codec.json.AbstractJackson2Codec;
import org.springframework.http.codec.json.JsonObjectDecoder;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Jackson2JsonDecoder
extends AbstractJackson2Codec
implements Decoder<Object> {
    private final JsonObjectDecoder fluxObjectDecoder = new JsonObjectDecoder(true);
    private final JsonObjectDecoder monoObjectDecoder = new JsonObjectDecoder(false);

    public Jackson2JsonDecoder() {
        super((ObjectMapper)Jackson2ObjectMapperBuilder.json().build());
    }

    public Jackson2JsonDecoder(ObjectMapper mapper) {
        super(mapper);
    }

    public boolean canDecode(ResolvableType elementType, MimeType mimeType, Object ... hints) {
        if (mimeType == null) {
            return true;
        }
        return JSON_MIME_TYPES.stream().anyMatch(m -> m.isCompatibleWith(mimeType));
    }

    public List<MimeType> getDecodableMimeTypes() {
        return JSON_MIME_TYPES;
    }

    public Flux<Object> decode(Publisher<DataBuffer> inputStream, ResolvableType elementType, MimeType mimeType, Object ... hints) {
        JsonObjectDecoder objectDecoder = this.fluxObjectDecoder;
        return this.decodeInternal(objectDecoder, inputStream, elementType, mimeType, hints);
    }

    public Mono<Object> decodeToMono(Publisher<DataBuffer> inputStream, ResolvableType elementType, MimeType mimeType, Object ... hints) {
        JsonObjectDecoder objectDecoder = this.monoObjectDecoder;
        return this.decodeInternal(objectDecoder, inputStream, elementType, mimeType, hints).single();
    }

    private Flux<Object> decodeInternal(JsonObjectDecoder objectDecoder, Publisher<DataBuffer> inputStream, ResolvableType elementType, MimeType mimeType, Object[] hints) {
        ObjectReader reader;
        JsonView jsonView;
        Assert.notNull(inputStream, (String)"'inputStream' must not be null");
        Assert.notNull((Object)elementType, (String)"'elementType' must not be null");
        MethodParameter methodParam = elementType.getSource() instanceof MethodParameter ? (MethodParameter)elementType.getSource() : null;
        Class contextClass = methodParam != null ? methodParam.getContainingClass() : null;
        JavaType javaType = this.getJavaType(elementType.getType(), contextClass);
        JsonView jsonView2 = jsonView = methodParam != null ? (JsonView)methodParam.getParameterAnnotation(JsonView.class) : null;
        if (jsonView != null) {
            Class[] classes = jsonView.value();
            if (classes.length != 1) {
                throw new IllegalArgumentException("@JsonView only supported for response body advice with exactly 1 class argument: " + methodParam);
            }
            reader = this.mapper.readerWithView(classes[0]).forType(javaType);
        } else {
            reader = this.mapper.readerFor(javaType);
        }
        return objectDecoder.decode(inputStream, elementType, mimeType, hints).map(dataBuffer -> {
            try {
                Object value = reader.readValue(dataBuffer.asInputStream());
                DataBufferUtils.release((DataBuffer)dataBuffer);
                return value;
            }
            catch (IOException ex) {
                return Flux.error((Throwable)new CodecException("Error while reading the data", (Throwable)ex));
            }
        });
    }
}

