/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.adapter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import org.springframework.web.server.adapter.DefaultServerWebExchange;
import org.springframework.web.server.handler.WebHandlerDecorator;
import org.springframework.web.server.session.DefaultWebSessionManager;
import org.springframework.web.server.session.WebSessionManager;
import reactor.core.publisher.Mono;

public class HttpWebHandlerAdapter
extends WebHandlerDecorator
implements HttpHandler {
    private static Log logger = LogFactory.getLog(HttpWebHandlerAdapter.class);
    private WebSessionManager sessionManager = new DefaultWebSessionManager();

    public HttpWebHandlerAdapter(WebHandler delegate) {
        super(delegate);
    }

    public void setSessionManager(WebSessionManager sessionManager) {
        Assert.notNull((Object)sessionManager, (String)"'sessionManager' must not be null.");
        this.sessionManager = sessionManager;
    }

    public WebSessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public Mono<Void> handle(ServerHttpRequest request, ServerHttpResponse response) {
        ServerWebExchange exchange = this.createExchange(request, response);
        return this.getDelegate().handle(exchange).otherwise(ex -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Could not complete request", ex);
            }
            response.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            return Mono.empty();
        }).then(response::setComplete);
    }

    protected ServerWebExchange createExchange(ServerHttpRequest request, ServerHttpResponse response) {
        return new DefaultServerWebExchange(request, response, this.sessionManager);
    }
}

