/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.session;

import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.springframework.util.Assert;
import org.springframework.web.server.session.ConfigurableWebSession;
import reactor.core.publisher.Mono;

public class DefaultWebSession
implements ConfigurableWebSession,
Serializable {
    private static final long serialVersionUID = -3567697426432961630L;
    private final String id;
    private final Map<String, Object> attributes;
    private final Clock clock;
    private final Instant creationTime;
    private volatile Instant lastAccessTime;
    private volatile Duration maxIdleTime;
    private AtomicReference<State> state = new AtomicReference();
    private volatile transient Supplier<Mono<Void>> saveOperation;

    public DefaultWebSession(String id, Clock clock) {
        Assert.notNull((Object)id, (String)"'id' is required.");
        Assert.notNull((Object)clock, (String)"'clock' is required.");
        this.id = id;
        this.clock = clock;
        this.attributes = new ConcurrentHashMap<String, Object>();
        this.lastAccessTime = this.creationTime = Instant.now(clock);
        this.maxIdleTime = Duration.ofMinutes(30L);
        this.state.set(State.NEW);
    }

    public DefaultWebSession(String id, Map<String, Object> attributes, Clock clock, Instant creationTime, Instant lastAccessTime, Duration maxIdleTime) {
        Assert.notNull((Object)id, (String)"'id' is required.");
        Assert.notNull((Object)clock, (String)"'clock' is required.");
        this.id = id;
        this.attributes = new ConcurrentHashMap<String, Object>(attributes);
        this.clock = clock;
        this.creationTime = creationTime;
        this.lastAccessTime = lastAccessTime;
        this.maxIdleTime = maxIdleTime;
        this.state.set(State.STARTED);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public <T> Optional<T> getAttribute(String name) {
        return Optional.ofNullable(this.attributes.get(name));
    }

    @Override
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void setLastAccessTime(Instant lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    @Override
    public Instant getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public void setMaxIdleTime(Duration maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    public Duration getMaxIdleTime() {
        return this.maxIdleTime;
    }

    @Override
    public void setSaveOperation(Supplier<Mono<Void>> saveOperation) {
        Assert.notNull(saveOperation, (String)"'saveOperation' is required.");
        this.saveOperation = saveOperation;
    }

    protected Supplier<Mono<Void>> getSaveOperation() {
        return this.saveOperation;
    }

    @Override
    public void start() {
        this.state.compareAndSet(State.NEW, State.STARTED);
    }

    @Override
    public boolean isStarted() {
        State value = this.state.get();
        return State.STARTED.equals((Object)value) || State.NEW.equals((Object)value) && !this.getAttributes().isEmpty();
    }

    @Override
    public Mono<Void> save() {
        return this.saveOperation.get();
    }

    @Override
    public boolean isExpired() {
        return this.isStarted() && !this.maxIdleTime.isNegative() && Instant.now(this.clock).minus(this.maxIdleTime).isAfter(this.lastAccessTime);
    }

    private static enum State {
        NEW,
        STARTED;

    }
}

