/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.time.Duration;
import java.util.Optional;

public class ServerSentEvent<T> {
    private final String id;
    private final String event;
    private final T data;
    private final Duration retry;
    private final String comment;

    private ServerSentEvent(String id, String event, T data, Duration retry, String comment) {
        this.id = id;
        this.event = event;
        this.data = data;
        this.retry = retry;
        this.comment = comment;
    }

    public static <T> Builder<T> builder() {
        return new BuilderImpl();
    }

    public static <T> Builder<T> builder(T data) {
        return new BuilderImpl<T>(data);
    }

    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    public Optional<String> event() {
        return Optional.ofNullable(this.event);
    }

    public Optional<T> data() {
        return Optional.ofNullable(this.data);
    }

    public Optional<Duration> retry() {
        return Optional.ofNullable(this.retry);
    }

    public Optional<String> comment() {
        return Optional.ofNullable(this.comment);
    }

    private static class BuilderImpl<T>
    implements Builder<T> {
        private T data;
        private String id;
        private String event;
        private Duration retry;
        private String comment;

        public BuilderImpl() {
        }

        public BuilderImpl(T data) {
            this.data = data;
        }

        @Override
        public Builder<T> id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder<T> event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public Builder<T> data(T data) {
            this.data = data;
            return this;
        }

        @Override
        public Builder<T> retry(Duration retry) {
            this.retry = retry;
            return this;
        }

        @Override
        public Builder<T> comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public ServerSentEvent<T> build() {
            return new ServerSentEvent(this.id, this.event, this.data, this.retry, this.comment);
        }
    }

    public static interface Builder<T> {
        public Builder<T> id(String var1);

        public Builder<T> event(String var1);

        public Builder<T> data(T var1);

        public Builder<T> retry(Duration var1);

        public Builder<T> comment(String var1);

        public ServerSentEvent<T> build();
    }
}

