/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.handler.codec.http.cookie.Cookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.ipc.netty.http.HttpChannel;

public class ReactorServerHttpRequest
extends AbstractServerHttpRequest {
    private final HttpChannel channel;
    private final NettyDataBufferFactory bufferFactory;

    public ReactorServerHttpRequest(HttpChannel request, NettyDataBufferFactory bufferFactory) {
        Assert.notNull((Object)"'request' must not be null");
        Assert.notNull((Object)bufferFactory, (String)"'bufferFactory' must not be null");
        this.channel = request;
        this.bufferFactory = bufferFactory;
    }

    public HttpChannel getReactorChannel() {
        return this.channel;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.channel.method().name());
    }

    @Override
    protected URI initUri() throws URISyntaxException {
        return new URI(this.channel.uri());
    }

    @Override
    protected HttpHeaders initHeaders() {
        HttpHeaders headers = new HttpHeaders();
        for (String name : this.channel.headers().names()) {
            headers.put(name, this.channel.headers().getAll(name));
        }
        return headers;
    }

    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap cookies = new LinkedMultiValueMap();
        for (CharSequence name : this.channel.cookies().keySet()) {
            for (Cookie cookie : (Set)this.channel.cookies().get(name)) {
                HttpCookie httpCookie = new HttpCookie(name.toString(), cookie.value());
                cookies.add((Object)name.toString(), (Object)httpCookie);
            }
        }
        return cookies;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.channel.receive().retain().map(arg_0 -> ((NettyDataBufferFactory)this.bufferFactory).wrap(arg_0));
    }
}

