/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.URI;
import java.util.function.Function;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.client.reactive.ReactorClientHttpRequest;
import org.springframework.http.client.reactive.ReactorClientHttpResponse;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.config.ClientOptions;
import reactor.ipc.netty.http.HttpClient;
import reactor.ipc.netty.http.HttpClientRequest;
import reactor.ipc.netty.http.HttpException;
import reactor.ipc.netty.http.HttpInbound;

public class ReactorClientHttpConnector
implements ClientHttpConnector {
    private final HttpClient httpClient;

    public ReactorClientHttpConnector() {
        this(ClientOptions.create().sslSupport());
    }

    public ReactorClientHttpConnector(ClientOptions clientOptions) {
        this.httpClient = HttpClient.create((ClientOptions)clientOptions);
    }

    @Override
    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        return this.httpClient.request(io.netty.handler.codec.http.HttpMethod.valueOf((String)method.name()), uri.toString(), httpClientRequest -> (Mono)requestCallback.apply(new ReactorClientHttpRequest(method, uri, (HttpClientRequest)httpClientRequest))).cast(HttpInbound.class).otherwise(HttpException.class, exc -> Mono.just((Object)exc.getChannel())).map(ReactorClientHttpResponse::new);
    }
}

