/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.BodyInserter;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.http.codec.UnsupportedMediaTypeException;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public abstract class BodyInserters {
    private static final ResolvableType RESOURCE_TYPE = ResolvableType.forClass(Resource.class);
    private static final ResolvableType SERVER_SIDE_EVENT_TYPE = ResolvableType.forClass(ServerSentEvent.class);

    public static <T> BodyInserter<T, ReactiveHttpOutputMessage> fromObject(T body) {
        Assert.notNull(body, (String)"'body' must not be null");
        return BodyInserter.of(BodyInserters.writeFunctionFor(Mono.just(body), ResolvableType.forInstance(body)), () -> body);
    }

    public static <S extends Publisher<T>, T> BodyInserter<S, ReactiveHttpOutputMessage> fromPublisher(S publisher, Class<T> elementClass) {
        Assert.notNull(publisher, (String)"'publisher' must not be null");
        Assert.notNull(elementClass, (String)"'elementClass' must not be null");
        return BodyInserter.of(BodyInserters.writeFunctionFor(publisher, ResolvableType.forClass(elementClass)), () -> publisher);
    }

    public static <S extends Publisher<T>, T> BodyInserter<S, ReactiveHttpOutputMessage> fromPublisher(S publisher, ResolvableType elementType) {
        Assert.notNull(publisher, (String)"'publisher' must not be null");
        Assert.notNull((Object)elementType, (String)"'elementType' must not be null");
        return BodyInserter.of(BodyInserters.writeFunctionFor(publisher, elementType), () -> publisher);
    }

    public static <T extends Resource> BodyInserter<T, ReactiveHttpOutputMessage> fromResource(T resource) {
        Assert.notNull(resource, (String)"'resource' must not be null");
        return BodyInserter.of((response, context) -> {
            HttpMessageWriter<Resource> messageWriter = BodyInserters.resourceHttpMessageWriter(context);
            return messageWriter.write((Publisher<Resource>)Mono.just((Object)resource), RESOURCE_TYPE, null, (ReactiveHttpOutputMessage)response, Collections.emptyMap());
        }, () -> resource);
    }

    private static HttpMessageWriter<Resource> resourceHttpMessageWriter(BodyInserter.Context context) {
        return context.messageWriters().get().filter(messageWriter -> messageWriter.canWrite(RESOURCE_TYPE, null)).findFirst().map(BodyInserters::cast).orElseThrow(() -> new IllegalStateException("Could not find HttpMessageWriter that supports Resources."));
    }

    public static <T, S extends Publisher<ServerSentEvent<T>>> BodyInserter<S, ServerHttpResponse> fromServerSentEvents(S eventsPublisher) {
        Assert.notNull(eventsPublisher, (String)"'eventsPublisher' must not be null");
        return BodyInserter.of((response, context) -> {
            HttpMessageWriter messageWriter = BodyInserters.sseMessageWriter(context);
            return messageWriter.write((Publisher)eventsPublisher, SERVER_SIDE_EVENT_TYPE, MediaType.TEXT_EVENT_STREAM, (ReactiveHttpOutputMessage)response, Collections.emptyMap());
        }, () -> eventsPublisher);
    }

    public static <T, S extends Publisher<T>> BodyInserter<S, ServerHttpResponse> fromServerSentEvents(S eventsPublisher, Class<T> eventClass) {
        Assert.notNull(eventsPublisher, (String)"'eventsPublisher' must not be null");
        Assert.notNull(eventClass, (String)"'eventClass' must not be null");
        return BodyInserters.fromServerSentEvents(eventsPublisher, ResolvableType.forClass(eventClass));
    }

    public static <T, S extends Publisher<T>> BodyInserter<S, ServerHttpResponse> fromServerSentEvents(S eventsPublisher, ResolvableType eventType) {
        Assert.notNull(eventsPublisher, (String)"'eventsPublisher' must not be null");
        Assert.notNull((Object)eventType, (String)"'eventType' must not be null");
        return BodyInserter.of((response, context) -> {
            HttpMessageWriter messageWriter = BodyInserters.sseMessageWriter(context);
            return messageWriter.write(eventsPublisher, eventType, MediaType.TEXT_EVENT_STREAM, (ReactiveHttpOutputMessage)response, Collections.emptyMap());
        }, () -> eventsPublisher);
    }

    private static <T> HttpMessageWriter<T> sseMessageWriter(BodyInserter.Context context) {
        return context.messageWriters().get().filter(messageWriter -> messageWriter.canWrite(SERVER_SIDE_EVENT_TYPE, MediaType.TEXT_EVENT_STREAM)).findFirst().map(BodyInserters::cast).orElseThrow(() -> new IllegalStateException("Could not find HttpMessageWriter that supports text/event-stream"));
    }

    private static <T, M extends ReactiveHttpOutputMessage> BiFunction<M, BodyInserter.Context, Mono<Void>> writeFunctionFor(Publisher<T> body, ResolvableType bodyType) {
        return (m, context) -> {
            MediaType contentType = m.getHeaders().getContentType();
            Supplier<Stream<HttpMessageWriter<?>>> messageWriters = context.messageWriters();
            return messageWriters.get().filter(messageWriter -> messageWriter.canWrite(bodyType, contentType)).findFirst().map(BodyInserters::cast).map(messageWriter -> messageWriter.write(body, bodyType, contentType, (ReactiveHttpOutputMessage)m, Collections.emptyMap())).orElseGet(() -> {
                List<MediaType> supportedMediaTypes = ((Stream)messageWriters.get()).flatMap(reader -> reader.getWritableMediaTypes().stream()).collect(Collectors.toList());
                UnsupportedMediaTypeException error = new UnsupportedMediaTypeException(contentType, supportedMediaTypes);
                return Mono.error((Throwable)((Object)error));
            });
        };
    }

    private static <T> HttpMessageWriter<T> cast(HttpMessageWriter<?> messageWriter) {
        return messageWriter;
    }

    static class DefaultBodyInserter<T, M extends ReactiveHttpOutputMessage>
    implements BodyInserter<T, M> {
        private final BiFunction<M, BodyInserter.Context, Mono<Void>> writer;
        private final Supplier<T> supplier;

        public DefaultBodyInserter(BiFunction<M, BodyInserter.Context, Mono<Void>> writer, Supplier<T> supplier) {
            this.writer = writer;
            this.supplier = supplier;
        }

        @Override
        public Mono<Void> insert(M outputMessage, BodyInserter.Context context) {
            return this.writer.apply(outputMessage, context);
        }

        @Override
        public T t() {
            return this.supplier.get();
        }
    }
}

