/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FormHttpMessageWriter
implements HttpMessageWriter<MultiValueMap<String, String>> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final ResolvableType MULTIVALUE_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, (Class[])new Class[]{String.class, String.class});
    private Charset defaultCharset = DEFAULT_CHARSET;

    public void setDefaultCharset(Charset charset) {
        Assert.notNull((Object)charset, (String)"'charset' must not be null");
        this.defaultCharset = charset;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    @Override
    public boolean canWrite(ResolvableType elementType, MediaType mediaType) {
        return MULTIVALUE_TYPE.isAssignableFrom(elementType) && (mediaType == null || MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(mediaType));
    }

    @Override
    public Mono<Void> write(Publisher<? extends MultiValueMap<String, String>> inputStream, ResolvableType elementType, MediaType mediaType, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        MediaType contentType = outputMessage.getHeaders().getContentType();
        if (contentType == null) {
            contentType = MediaType.APPLICATION_FORM_URLENCODED;
            outputMessage.getHeaders().setContentType(contentType);
        }
        Charset charset = this.getMediaTypeCharset(contentType);
        return Flux.from(inputStream).single().map(form -> this.generateForm((MultiValueMap<String, String>)form, charset)).then(value -> {
            ByteBuffer byteBuffer = charset.encode((String)value);
            DataBuffer buffer = outputMessage.bufferFactory().wrap(byteBuffer);
            outputMessage.getHeaders().setContentLength(byteBuffer.remaining());
            return outputMessage.writeWith((Publisher<DataBuffer>)Mono.just((Object)buffer));
        });
    }

    private Charset getMediaTypeCharset(MediaType mediaType) {
        if (mediaType != null && mediaType.getCharset() != null) {
            return mediaType.getCharset();
        }
        return this.getDefaultCharset();
    }

    private String generateForm(MultiValueMap<String, String> form, Charset charset) {
        StringBuilder builder = new StringBuilder();
        try {
            Iterator names = form.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                Iterator values = ((List)form.get((Object)name)).iterator();
                while (values.hasNext()) {
                    String value = (String)values.next();
                    builder.append(URLEncoder.encode(name, charset.name()));
                    if (value == null) continue;
                    builder.append('=');
                    builder.append(URLEncoder.encode(value, charset.name()));
                    if (!values.hasNext()) continue;
                    builder.append('&');
                }
                if (!names.hasNext()) continue;
                builder.append('&');
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
        return builder.toString();
    }

    @Override
    public List<MediaType> getWritableMediaTypes() {
        return Collections.singletonList(MediaType.APPLICATION_FORM_URLENCODED);
    }
}

