/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.reactive;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.client.reactive.ClientRequest;
import org.springframework.web.client.reactive.ClientResponse;
import org.springframework.web.client.reactive.ExchangeFilterFunction;
import org.springframework.web.client.reactive.WebClientException;
import reactor.core.publisher.Mono;

public abstract class ExchangeFilterFunctions {
    public static ExchangeFilterFunction clientError() {
        return ExchangeFilterFunctions.statusError(HttpStatus::is4xxClientError);
    }

    public static ExchangeFilterFunction serverError() {
        return ExchangeFilterFunctions.statusError(HttpStatus::is5xxServerError);
    }

    public static ExchangeFilterFunction clientOrServerError() {
        return ExchangeFilterFunctions.clientError().andThen(ExchangeFilterFunctions.serverError());
    }

    private static ExchangeFilterFunction statusError(Predicate<HttpStatus> predicate) {
        Function<ClientResponse, Optional<? extends Throwable>> mapper = clientResponse -> {
            HttpStatus status = clientResponse.statusCode();
            if (predicate.test(status)) {
                return Optional.of(new WebClientException("ClientResponse has invalid status code: " + status.value() + " " + status.getReasonPhrase()));
            }
            return Optional.empty();
        };
        return ExchangeFilterFunctions.errorMapper(mapper);
    }

    public static ExchangeFilterFunction errorPredicate(Predicate<ClientResponse> predicate) {
        Assert.notNull(predicate, (String)"'predicate' must not be null");
        Function<ClientResponse, Optional<? extends Throwable>> mapper = clientResponse -> {
            if (predicate.test((ClientResponse)clientResponse)) {
                return Optional.of(new WebClientException("ClientResponse does not satisfy predicate : " + predicate));
            }
            return Optional.empty();
        };
        return ExchangeFilterFunctions.errorMapper(mapper);
    }

    public static ExchangeFilterFunction errorMapper(Function<ClientResponse, Optional<? extends Throwable>> mapper) {
        Assert.notNull(mapper, (String)"'mapper' must not be null");
        return ExchangeFilterFunction.ofResponseProcessor(clientResponse -> {
            Optional error = (Optional)mapper.apply((ClientResponse)clientResponse);
            return error.isPresent() ? Mono.error((Throwable)((Throwable)error.get())) : Mono.just((Object)clientResponse);
        });
    }

    public static ExchangeFilterFunction basicAuthentication(String username, String password) {
        Assert.notNull((Object)username, (String)"'username' must not be null");
        Assert.notNull((Object)password, (String)"'password' must not be null");
        return ExchangeFilterFunction.ofRequestProcessor(clientRequest -> {
            String authorization = ExchangeFilterFunctions.authorization(username, password);
            ClientRequest authorizedRequest = ((ClientRequest.BodyBuilder)ClientRequest.from(clientRequest).header("Authorization", authorization)).body(clientRequest.inserter());
            return Mono.just(authorizedRequest);
        });
    }

    private static String authorization(String username, String password) {
        String credentials = username + ":" + password;
        byte[] credentialBytes = credentials.getBytes(StandardCharsets.ISO_8859_1);
        byte[] encodedBytes = Base64.getEncoder().encode(credentialBytes);
        String encodedCredentials = new String(encodedBytes, StandardCharsets.ISO_8859_1);
        return "Basic " + encodedCredentials;
    }
}

