/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.reactive;

import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.util.Assert;
import org.springframework.web.client.reactive.ClientRequest;
import org.springframework.web.client.reactive.ClientResponse;
import org.springframework.web.client.reactive.DefaultWebClientBuilder;
import org.springframework.web.client.reactive.ExchangeFilterFunction;
import org.springframework.web.client.reactive.WebClientStrategies;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface WebClient {
    public Mono<ClientResponse> exchange(ClientRequest<?> var1);

    public <T> Mono<T> retrieveMono(ClientRequest<?> var1, Class<? extends T> var2);

    public <T> Flux<T> retrieveFlux(ClientRequest<?> var1, Class<? extends T> var2);

    public static WebClient create(ClientHttpConnector connector) {
        return WebClient.builder(connector).build();
    }

    public static Builder builder(ClientHttpConnector connector) {
        Assert.notNull((Object)connector, (String)"'connector' must not be null");
        return new DefaultWebClientBuilder(connector);
    }

    public static interface Builder {
        public Builder strategies(WebClientStrategies var1);

        public Builder filter(ExchangeFilterFunction var1);

        public WebClient build();
    }
}

