/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server;

import java.security.Principal;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebExchangeDecorator;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

class DefaultServerWebExchangeMutativeBuilder
implements ServerWebExchange.MutativeBuilder {
    private final ServerWebExchange delegate;
    private ServerHttpRequest request;
    private ServerHttpResponse response;
    private Mono<Principal> user;
    private Mono<WebSession> session;
    private Mono<MultiValueMap<String, String>> formData;

    public DefaultServerWebExchangeMutativeBuilder(ServerWebExchange delegate) {
        Assert.notNull((Object)delegate, (String)"'delegate' is required.");
        this.delegate = delegate;
    }

    @Override
    public ServerWebExchange.MutativeBuilder setRequest(ServerHttpRequest request) {
        this.request = request;
        return this;
    }

    @Override
    public ServerWebExchange.MutativeBuilder setResponse(ServerHttpResponse response) {
        this.response = response;
        return this;
    }

    @Override
    public ServerWebExchange.MutativeBuilder setPrincipal(Mono<Principal> user) {
        this.user = user;
        return this;
    }

    @Override
    public ServerWebExchange.MutativeBuilder setSession(Mono<WebSession> session) {
        this.session = session;
        return this;
    }

    @Override
    public ServerWebExchange.MutativeBuilder setFormData(Mono<MultiValueMap<String, String>> formData) {
        this.formData = formData;
        return this;
    }

    @Override
    public ServerWebExchange build() {
        return new MutativeDecorator(this.delegate, this.request, this.response, this.user, this.session, this.formData);
    }

    private static class MutativeDecorator
    extends ServerWebExchangeDecorator {
        private final ServerHttpRequest request;
        private final ServerHttpResponse response;
        private final Mono<Principal> userMono;
        private final Mono<WebSession> session;
        private final Mono<MultiValueMap<String, String>> formData;

        public MutativeDecorator(ServerWebExchange delegate, ServerHttpRequest request, ServerHttpResponse response, Mono<Principal> user, Mono<WebSession> session, Mono<MultiValueMap<String, String>> formData) {
            super(delegate);
            this.request = request;
            this.response = response;
            this.userMono = user;
            this.session = session;
            this.formData = formData;
        }

        @Override
        public ServerHttpRequest getRequest() {
            return this.request != null ? this.request : this.getDelegate().getRequest();
        }

        @Override
        public ServerHttpResponse getResponse() {
            return this.response != null ? this.response : this.getDelegate().getResponse();
        }

        @Override
        public Mono<WebSession> getSession() {
            return this.session != null ? this.session : this.getDelegate().getSession();
        }

        @Override
        public <T extends Principal> Mono<T> getPrincipal() {
            return this.userMono != null ? this.userMono : this.getDelegate().getPrincipal();
        }

        @Override
        public Mono<MultiValueMap<String, String>> getFormData() {
            return this.formData != null ? this.formData : this.getDelegate().getFormData();
        }
    }
}

