/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public abstract class HttpHandlerAdapterSupport {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final HttpHandler httpHandler;

    public HttpHandlerAdapterSupport(HttpHandler httpHandler) {
        Assert.notNull((Object)httpHandler, (String)"'httpHandler' is required");
        this.httpHandler = httpHandler;
    }

    public HttpHandlerAdapterSupport(Map<String, HttpHandler> handlerMap) {
        this.httpHandler = new CompositeHttpHandler(handlerMap);
    }

    public HttpHandler getHttpHandler() {
        return this.httpHandler;
    }

    private static class CompositeHttpHandler
    implements HttpHandler {
        private final Map<String, HttpHandler> handlerMap;

        public CompositeHttpHandler(Map<String, HttpHandler> handlerMap) {
            Assert.notEmpty(handlerMap);
            this.handlerMap = CompositeHttpHandler.initHandlerMap(handlerMap);
        }

        private static Map<String, HttpHandler> initHandlerMap(Map<String, HttpHandler> inputMap) {
            inputMap.keySet().stream().forEach(CompositeHttpHandler::validateContextPath);
            return new LinkedHashMap<String, HttpHandler>(inputMap);
        }

        private static void validateContextPath(String contextPath) {
            Assert.hasText((String)contextPath, (String)"contextPath must not be empty");
            if (!contextPath.equals("/")) {
                Assert.isTrue((boolean)contextPath.startsWith("/"), (String)"contextPath must begin with '/'");
                Assert.isTrue((!contextPath.endsWith("/") ? 1 : 0) != 0, (String)"contextPath must not end with '/'");
            }
        }

        @Override
        public Mono<Void> handle(ServerHttpRequest request, ServerHttpResponse response) {
            String path = this.getPathToUse(request);
            return this.handlerMap.entrySet().stream().filter(entry -> path.startsWith((String)entry.getKey())).findFirst().map(entry -> {
                String contextPath = request.getContextPath() + (String)entry.getKey();
                ServerHttpRequest mutatedRequest = request.mutate().contextPath(contextPath).build();
                HttpHandler handler = (HttpHandler)entry.getValue();
                return handler.handle(mutatedRequest, response);
            }).orElseGet(() -> {
                response.setStatusCode(HttpStatus.NOT_FOUND);
                response.setComplete();
                return Mono.empty();
            });
        }

        private String getPathToUse(ServerHttpRequest request) {
            String path = request.getURI().getRawPath();
            String contextPath = request.getContextPath();
            if (!StringUtils.hasText((String)contextPath)) {
                return path;
            }
            int contextLength = contextPath.length();
            return path.length() > contextLength ? path.substring(contextLength) : "";
        }
    }
}

