/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.cookie.Cookie;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import rx.Observable;
import rx.RxReactiveStreams;

public class RxNettyServerHttpRequest
extends AbstractServerHttpRequest {
    private final HttpServerRequest<ByteBuf> request;
    private final NettyDataBufferFactory dataBufferFactory;

    public RxNettyServerHttpRequest(HttpServerRequest<ByteBuf> request, NettyDataBufferFactory dataBufferFactory) {
        super(RxNettyServerHttpRequest.initUri(request), RxNettyServerHttpRequest.initHeaders(request));
        Assert.notNull((Object)dataBufferFactory, (String)"'dataBufferFactory' must not be null");
        this.request = request;
        this.dataBufferFactory = dataBufferFactory;
    }

    private static URI initUri(HttpServerRequest<ByteBuf> request) {
        Assert.notNull((Object)"'request', request must not be null");
        try {
            URI uri = new URI(request.getUri());
            InetSocketAddress remoteAddress = null;
            if (!StringUtils.isEmpty((Object)request.getHostHeader())) {
                HttpHeaders headers = new HttpHeaders();
                headers.add("Host", request.getHostHeader());
                remoteAddress = headers.getHost();
            }
            return new URI(uri.getScheme(), uri.getUserInfo(), remoteAddress != null ? remoteAddress.getHostString() : null, remoteAddress != null ? remoteAddress.getPort() : -1, uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Could not get URI: " + ex.getMessage(), ex);
        }
    }

    private static HttpHeaders initHeaders(HttpServerRequest<ByteBuf> request) {
        HttpHeaders headers = new HttpHeaders();
        for (String name : request.getHeaderNames()) {
            headers.put(name, request.getAllHeaderValues((CharSequence)name));
        }
        return headers;
    }

    public HttpServerRequest<ByteBuf> getRxNettyRequest() {
        return this.request;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.request.getHttpMethod().name());
    }

    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap cookies = new LinkedMultiValueMap();
        for (String name : this.request.getCookies().keySet()) {
            for (Cookie cookie : (Set)this.request.getCookies().get(name)) {
                HttpCookie httpCookie = new HttpCookie(name, cookie.value());
                cookies.add((Object)name, (Object)httpCookie);
            }
        }
        return cookies;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        Observable content = this.request.getContent().map(arg_0 -> ((NettyDataBufferFactory)this.dataBufferFactory).wrap(arg_0));
        return Flux.from((Publisher)RxReactiveStreams.toPublisher((Observable)content));
    }
}

