/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.AbstractListenerServerHttpResponse;
import org.springframework.http.server.reactive.AbstractListenerWriteFlushProcessor;
import org.springframework.http.server.reactive.AbstractListenerWriteProcessor;
import org.springframework.util.Assert;

public class ServletServerHttpResponse
extends AbstractListenerServerHttpResponse {
    private final HttpServletResponse response;
    private final int bufferSize;
    private volatile ResponseBodyFlushProcessor bodyFlushProcessor;
    private volatile ResponseBodyProcessor bodyProcessor;
    private volatile boolean flushOnNext;

    public ServletServerHttpResponse(HttpServletResponse response, AsyncContext asyncContext, DataBufferFactory bufferFactory, int bufferSize) throws IOException {
        super(bufferFactory);
        Assert.notNull((Object)response, (String)"HttpServletResponse must not be null");
        Assert.notNull((Object)bufferFactory, (String)"DataBufferFactory must not be null");
        Assert.isTrue((bufferSize > 0 ? 1 : 0) != 0, (String)"'bufferSize' must be greater than 0");
        this.response = response;
        this.bufferSize = bufferSize;
        asyncContext.addListener((AsyncListener)new ResponseAsyncListener());
        response.getOutputStream().setWriteListener((WriteListener)new ResponseBodyWriteListener());
    }

    public HttpServletResponse getServletResponse() {
        return this.response;
    }

    @Override
    protected void applyStatusCode() {
        HttpStatus statusCode = this.getStatusCode();
        if (statusCode != null) {
            this.getServletResponse().setStatus(statusCode.value());
        }
    }

    @Override
    protected void applyHeaders() {
        Charset charset;
        for (Map.Entry<String, List<String>> entry : this.getHeaders().entrySet()) {
            String headerName = entry.getKey();
            for (String headerValue : entry.getValue()) {
                this.response.addHeader(headerName, headerValue);
            }
        }
        MediaType contentType = this.getHeaders().getContentType();
        if (this.response.getContentType() == null && contentType != null) {
            this.response.setContentType(contentType.toString());
        }
        Charset charset2 = charset = contentType != null ? contentType.getCharset() : null;
        if (this.response.getCharacterEncoding() == null && charset != null) {
            this.response.setCharacterEncoding(charset.name());
        }
    }

    @Override
    protected void applyCookies() {
        for (String name : this.getCookies().keySet()) {
            for (ResponseCookie httpCookie : (List)this.getCookies().get((Object)name)) {
                Cookie cookie = new Cookie(name, httpCookie.getValue());
                if (!httpCookie.getMaxAge().isNegative()) {
                    cookie.setMaxAge((int)httpCookie.getMaxAge().getSeconds());
                }
                httpCookie.getDomain().ifPresent(arg_0 -> ((Cookie)cookie).setDomain(arg_0));
                httpCookie.getPath().ifPresent(arg_0 -> ((Cookie)cookie).setPath(arg_0));
                cookie.setSecure(httpCookie.isSecure());
                cookie.setHttpOnly(httpCookie.isHttpOnly());
                this.response.addCookie(cookie);
            }
        }
    }

    @Override
    protected Processor<? super Publisher<? extends DataBuffer>, Void> createBodyFlushProcessor() {
        ResponseBodyFlushProcessor processor;
        this.bodyFlushProcessor = processor = new ResponseBodyFlushProcessor();
        return processor;
    }

    private void flush() throws IOException {
        ServletOutputStream outputStream = this.response.getOutputStream();
        if (outputStream.isReady()) {
            try {
                outputStream.flush();
                this.flushOnNext = false;
            }
            catch (IOException ex) {
                this.flushOnNext = true;
                throw ex;
            }
        } else {
            this.flushOnNext = true;
        }
    }

    private class ResponseBodyProcessor
    extends AbstractListenerWriteProcessor<DataBuffer> {
        private final ServletOutputStream outputStream;
        private final int bufferSize;

        public ResponseBodyProcessor(ServletOutputStream outputStream, int bufferSize) {
            this.outputStream = outputStream;
            this.bufferSize = bufferSize;
        }

        @Override
        protected boolean isWritePossible() {
            return this.outputStream.isReady();
        }

        @Override
        protected void releaseData() {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("releaseBuffer: " + this.currentData));
            }
            DataBufferUtils.release((DataBuffer)((DataBuffer)this.currentData));
            this.currentData = null;
        }

        @Override
        protected boolean isDataEmpty(DataBuffer dataBuffer) {
            return dataBuffer.readableByteCount() == 0;
        }

        @Override
        protected boolean write(DataBuffer dataBuffer) throws IOException {
            if (ServletServerHttpResponse.this.flushOnNext) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"flush");
                }
                ServletServerHttpResponse.this.flush();
            }
            boolean ready = this.outputStream.isReady();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("write: " + dataBuffer + " ready: " + ready));
            }
            if (ready) {
                int total = dataBuffer.readableByteCount();
                int written = this.writeDataBuffer(dataBuffer);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("written: " + written + " total: " + total));
                }
                return written == total;
            }
            return false;
        }

        private int writeDataBuffer(DataBuffer dataBuffer) throws IOException {
            InputStream input = dataBuffer.asInputStream();
            int bytesWritten = 0;
            byte[] buffer = new byte[this.bufferSize];
            int bytesRead = -1;
            while (this.outputStream.isReady() && (bytesRead = input.read(buffer)) != -1) {
                this.outputStream.write(buffer, 0, bytesRead);
                bytesWritten += bytesRead;
            }
            return bytesWritten;
        }
    }

    private class ResponseBodyFlushProcessor
    extends AbstractListenerWriteFlushProcessor<DataBuffer> {
        private ResponseBodyFlushProcessor() {
        }

        @Override
        protected Processor<? super DataBuffer, Void> createWriteProcessor() {
            try {
                ServletOutputStream outputStream = ServletServerHttpResponse.this.response.getOutputStream();
                ServletServerHttpResponse.this.bodyProcessor = new ResponseBodyProcessor(outputStream, ServletServerHttpResponse.this.bufferSize);
                return ServletServerHttpResponse.this.bodyProcessor;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        @Override
        protected void flush() throws IOException {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"flush");
            }
            ServletServerHttpResponse.this.flush();
        }
    }

    private class ResponseBodyWriteListener
    implements WriteListener {
        private ResponseBodyWriteListener() {
        }

        public void onWritePossible() throws IOException {
            if (ServletServerHttpResponse.this.bodyProcessor != null) {
                ServletServerHttpResponse.this.bodyProcessor.onWritePossible();
            }
        }

        public void onError(Throwable ex) {
            if (ServletServerHttpResponse.this.bodyProcessor != null) {
                ServletServerHttpResponse.this.bodyProcessor.cancel();
                ServletServerHttpResponse.this.bodyProcessor.onError(ex);
            }
        }
    }

    private final class ResponseAsyncListener
    implements AsyncListener {
        private ResponseAsyncListener() {
        }

        public void onStartAsync(AsyncEvent event) {
        }

        public void onTimeout(AsyncEvent event) {
            Throwable ex = event.getThrowable();
            ex = ex != null ? ex : new IllegalStateException("Async operation timeout.");
            this.handleError(ex);
        }

        public void onError(AsyncEvent event) {
            this.handleError(event.getThrowable());
        }

        void handleError(Throwable ex) {
            if (ServletServerHttpResponse.this.bodyFlushProcessor != null) {
                ServletServerHttpResponse.this.bodyFlushProcessor.cancel();
                ServletServerHttpResponse.this.bodyFlushProcessor.onError(ex);
            }
            if (ServletServerHttpResponse.this.bodyProcessor != null) {
                ServletServerHttpResponse.this.bodyProcessor.cancel();
                ServletServerHttpResponse.this.bodyProcessor.onError(ex);
            }
        }

        public void onComplete(AsyncEvent event) {
            if (ServletServerHttpResponse.this.bodyFlushProcessor != null) {
                ServletServerHttpResponse.this.bodyFlushProcessor.cancel();
                ServletServerHttpResponse.this.bodyFlushProcessor.onComplete();
            }
            if (ServletServerHttpResponse.this.bodyProcessor != null) {
                ServletServerHttpResponse.this.bodyProcessor.cancel();
                ServletServerHttpResponse.this.bodyProcessor.onComplete();
            }
        }
    }
}

